/*
 * Decompiled with CFR 0.152.
 */
package model.subrecorddata;

import java.util.Arrays;
import java.util.HashMap;
import model.ModelFunctions;
import model.subrecorddata.SubRecordData;

public class SubrecordDataNPCO
implements SubRecordData {
    int number;
    String item;

    public SubrecordDataNPCO(byte[] bytes) {
        this.number = ModelFunctions.getIntFromBytes(Arrays.copyOfRange(bytes, 0, 4));
        this.item = String.valueOf(ModelFunctions.getStringFromBytes(Arrays.copyOfRange(bytes, 4, bytes.length)).trim()) + '\u0000';
    }

    @Override
    public byte[] getRawData() {
        byte[] bytes = ModelFunctions.getBytesFromString(this.item);
        byte[] idBytes = new byte[32];
        System.arraycopy(bytes, 0, idBytes, 0, bytes.length);
        byte[] countBytes = ModelFunctions.getBytesFromInt(this.number);
        byte[] completeBytes = new byte[36];
        System.arraycopy(countBytes, 0, completeBytes, 0, 4);
        System.arraycopy(idBytes, 0, completeBytes, 4, 32);
        return completeBytes;
    }

    public void setNumberByString(String stringValue) {
        HashMap<String, Float> variables = new HashMap<String, Float>();
        variables.put("number", new Float(this.number));
        this.number = Math.round(ModelFunctions.evaluateMathematicalExpression(stringValue, variables));
    }

    public void setItemByString(String stringValue) {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("item", this.item);
        this.item = ModelFunctions.evaluateStringExpression(stringValue, variables);
        if (!this.item.endsWith("\u0000")) {
            this.item = String.valueOf(this.item) + '\u0000';
        }
    }

    public String getNumberAsString() {
        return String.valueOf(this.number);
    }

    public String getItemAsString() {
        return this.item.substring(0, this.item.length() - 1);
    }

    @Override
    public void setValueByString(String stringValue) {
        String[] splitValues = stringValue.split(";");
        if (splitValues.length != 2) {
            throw new IllegalArgumentException("");
        }
        this.setNumberByString(splitValues[0]);
        this.setItemByString(splitValues[1]);
    }

    @Override
    public String getValueAsString() {
        return String.valueOf(this.getNumberAsString()) + ";" + this.getItemAsString();
    }
}

