/*
 * Decompiled with CFR 0.152.
 */
package model.subrecorddata;

import java.util.HashMap;
import model.ModelFunctions;
import model.subrecorddata.SubRecordData;

public class SubRecordDataString
implements SubRecordData {
    private String value;
    private String key;
    private int minimumLength;
    private int maximumLength;
    private boolean nullEnd;

    public SubRecordDataString(byte[] bytes, String key, int minimumLength, int maximumLength) {
        this.key = key;
        this.minimumLength = minimumLength;
        this.maximumLength = maximumLength;
        this.nullEnd = true;
        this.value = ModelFunctions.getStringFromBytes(bytes);
    }

    public SubRecordDataString(byte[] bytes, String key, int minimumLength, int maximumLength, boolean nullEnd) {
        this.key = key;
        this.minimumLength = minimumLength;
        this.maximumLength = maximumLength;
        this.nullEnd = nullEnd;
        this.value = ModelFunctions.getStringFromBytes(bytes);
    }

    public SubRecordDataString(byte[] bytes, String key, int minimumLength, int maximumLength, boolean nullEnd, boolean removeLinewraps) {
        this.key = key;
        this.minimumLength = minimumLength;
        this.maximumLength = maximumLength;
        this.nullEnd = nullEnd;
        this.value = ModelFunctions.getStringFromBytes(bytes);
        if (removeLinewraps) {
            this.value = this.value.replaceAll("\n", "");
            this.value = this.value.replaceAll("\r", "");
        }
    }

    public SubRecordDataString(String value, String key, int minimumLength, int maximumLength) {
        this.key = key;
        this.minimumLength = minimumLength;
        this.maximumLength = maximumLength;
        this.nullEnd = true;
        this.setValue(value);
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        if (value.length() < this.minimumLength || value.length() > this.maximumLength) {
            throw new IllegalArgumentException("The passed string must have a minimum length of " + this.minimumLength + " and a maximum length of " + this.maximumLength + "." + " Length of passed string:" + value.length());
        }
        if (!value.endsWith("\u0000") && this.nullEnd) {
            value = String.valueOf(value) + '\u0000';
        }
        this.value = value;
    }

    @Override
    public void setValueByString(String stringValue) {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put(this.key, this.value);
        String value = ModelFunctions.evaluateStringExpression(stringValue, variables);
        this.setValue(value);
    }

    @Override
    public String getValueAsString() {
        if (this.nullEnd && this.value.endsWith("\u0000")) {
            return this.value.substring(0, this.value.length() - 1);
        }
        return this.value;
    }

    @Override
    public byte[] getRawData() {
        return ModelFunctions.getBytesFromString(this.value);
    }
}

