/*
 * Decompiled with CFR 0.152.
 */
package model.subrecorddata;

import java.util.HashMap;
import model.ModelFunctions;
import model.subrecorddata.SubRecordData;

public class SubRecordDataShort
implements SubRecordData {
    private short value;
    private String key;

    public SubRecordDataShort(byte[] bytes, String key) {
        if (bytes.length != 2) {
            throw new IllegalArgumentException("The passed bytes array must consist of two bytes.");
        }
        this.key = key;
        this.value = ModelFunctions.getShortFromBytes(bytes);
    }

    @Override
    public byte[] getRawData() {
        return ModelFunctions.getBytesFromShort(this.value);
    }

    @Override
    public void setValueByString(String stringValue) {
        HashMap<String, Float> variables = new HashMap<String, Float>();
        variables.put(this.key, new Float(this.value));
        this.value = (short)Math.round(ModelFunctions.evaluateMathematicalExpression(stringValue, variables));
    }

    @Override
    public String getValueAsString() {
        return String.valueOf(this.value);
    }
}

