/*
 * Decompiled with CFR 0.152.
 */
package model.subrecorddata;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import model.ModelFunctions;
import model.subrecorddata.SubRecordData;

public class SubRecordDataSCVR
implements SubRecordData {
    private static final Map<Character, String> typeToTypeName = new HashMap<Character, String>();
    private static final Map<String, Character> typeNameToType = new HashMap<String, Character>();
    private static final Map<Character, String> compareOpToCompareOpName;
    private static final Map<String, Character> compareOpNameToCompareOp;
    private byte index;
    private byte type;
    private String function;
    private byte compareOp;
    private String name;

    static {
        typeToTypeName.put(Character.valueOf('\u0000'), "");
        typeToTypeName.put(Character.valueOf('0'), "?");
        typeToTypeName.put(Character.valueOf('1'), "Function");
        typeToTypeName.put(Character.valueOf('2'), "Global");
        typeToTypeName.put(Character.valueOf('3'), "Local");
        typeToTypeName.put(Character.valueOf('4'), "Journal");
        typeToTypeName.put(Character.valueOf('5'), "Item");
        typeToTypeName.put(Character.valueOf('6'), "Dead");
        typeToTypeName.put(Character.valueOf('7'), "Not ID");
        typeToTypeName.put(Character.valueOf('8'), "Not Faction");
        typeToTypeName.put(Character.valueOf('9'), "Not Class");
        typeToTypeName.put(Character.valueOf('A'), "Not Race");
        typeToTypeName.put(Character.valueOf('B'), "Not Cell");
        typeToTypeName.put(Character.valueOf('C'), "Not Local");
        for (Character key : typeToTypeName.keySet()) {
            typeNameToType.put(typeToTypeName.get(key), key);
        }
        compareOpToCompareOpName = new HashMap<Character, String>();
        compareOpNameToCompareOp = new HashMap<String, Character>();
        compareOpToCompareOpName.put(Character.valueOf('\u0000'), "");
        compareOpToCompareOpName.put(Character.valueOf('0'), "=");
        compareOpToCompareOpName.put(Character.valueOf('1'), "!=");
        compareOpToCompareOpName.put(Character.valueOf('2'), ">");
        compareOpToCompareOpName.put(Character.valueOf('3'), ">=");
        compareOpToCompareOpName.put(Character.valueOf('4'), "<");
        compareOpToCompareOpName.put(Character.valueOf('5'), "<=");
        for (Character key : compareOpToCompareOpName.keySet()) {
            compareOpNameToCompareOp.put(compareOpToCompareOpName.get(key), key);
        }
    }

    public SubRecordDataSCVR(byte[] bytes) {
        this.index = bytes[0];
        this.type = bytes[1];
        this.function = ModelFunctions.getStringFromBytes(new byte[]{bytes[2], bytes[3]});
        this.compareOp = bytes[4];
        this.name = bytes.length > 5 ? ModelFunctions.getStringFromBytes(Arrays.copyOfRange(bytes, 5, bytes.length)) : null;
    }

    public SubRecordDataSCVR(int numberIndex) {
        this.index = ModelFunctions.getByteFromChar(String.valueOf(numberIndex).charAt(0));
        this.type = 0;
        this.function = "";
        this.compareOp = 0;
        this.name = "";
    }

    @Override
    public byte[] getRawData() {
        ByteBuffer bb;
        byte[] valueBytes = null;
        if (this.name == null) {
            bb = ModelFunctions.getByteBufferToFill(5);
        } else {
            valueBytes = ModelFunctions.getBytesFromString(this.name);
            bb = ModelFunctions.getByteBufferToFill(5 + valueBytes.length);
        }
        bb.put(this.index);
        bb.put(this.type);
        bb.put(ModelFunctions.getBytesFromString(this.function));
        bb.put(this.compareOp);
        if (this.name != null) {
            bb.put(valueBytes);
        }
        return bb.array();
    }

    public void setValueByStringFor(String stringValue, String variable) {
        HashMap<String, String> variables = new HashMap<String, String>();
        char indexChar = ModelFunctions.getCharFromByte(this.index);
        int index = Integer.parseInt(String.valueOf(indexChar)) + 1;
        if (variable.equals("type")) {
            variables.put("func" + index + "Type", typeToTypeName.get(Character.valueOf(ModelFunctions.getCharFromByte(this.type))));
            stringValue = ModelFunctions.evaluateStringExpression(stringValue);
            this.type = ModelFunctions.getByteFromChar(typeNameToType.get(stringValue).charValue());
        } else if (variable.equals("function")) {
            variables.put("func" + index + "Func", this.function);
            this.function = stringValue = ModelFunctions.evaluateStringExpression(stringValue);
        } else if (variable.equals("compareOp")) {
            variables.put("func" + index + "CompareOp", compareOpToCompareOpName.get(Character.valueOf(ModelFunctions.getCharFromByte(this.compareOp))));
            stringValue = ModelFunctions.evaluateStringExpression(stringValue);
            this.compareOp = ModelFunctions.getByteFromChar(compareOpNameToCompareOp.get(stringValue).charValue());
        } else if (variable.equals("value")) {
            variables.put("func" + index + "Value", this.name);
            stringValue = ModelFunctions.evaluateStringExpression(stringValue, variables);
            this.name = stringValue.length() > 0 ? stringValue : null;
        } else {
            throw new IllegalArgumentException(String.valueOf(variable) + " can not be retrieved.");
        }
    }

    public String getValueAsStringOf(String variable) {
        if (variable.equals("type")) {
            return typeToTypeName.get(Character.valueOf(ModelFunctions.getCharFromByte(this.type)));
        }
        if (variable.equals("function")) {
            return this.function;
        }
        if (variable.equals("compareOp")) {
            return compareOpToCompareOpName.get(Character.valueOf(ModelFunctions.getCharFromByte(this.compareOp)));
        }
        if (variable.equals("value")) {
            if (this.name == null) {
                return "";
            }
            return this.name;
        }
        throw new IllegalArgumentException(String.valueOf(variable) + " can not be retrieved.");
    }

    @Override
    public void setValueByString(String stringValue) {
    }

    @Override
    public String getValueAsString() {
        return null;
    }

    public int getNumberIndex() {
        return Integer.parseInt(String.valueOf(ModelFunctions.getCharFromByte(this.index)));
    }

    public void setName(String name) {
        this.name = name;
    }
}

