/*
 * Decompiled with CFR 0.152.
 */
package model.subrecorddata;

import java.nio.ByteBuffer;
import java.util.HashMap;
import model.ModelFunctions;
import model.subrecorddata.SubRecordData;

public class SubRecordDataObjectCoordinates
implements SubRecordData {
    private float xPos;
    private float yPos;
    private float zPos;
    private float xRotate;
    private float yRotate;
    private float zRotate;

    public SubRecordDataObjectCoordinates(byte[] bytes) {
        ByteBuffer bb = ModelFunctions.getByteBufferFromBytes(bytes);
        this.xPos = bb.getFloat();
        this.yPos = bb.getFloat();
        this.zPos = bb.getFloat();
        this.xRotate = bb.getFloat();
        this.yRotate = bb.getFloat();
        this.zRotate = bb.getFloat();
    }

    @Override
    public byte[] getRawData() {
        ByteBuffer bb = ModelFunctions.getByteBufferToFill(24);
        bb.putFloat(this.xPos);
        bb.putFloat(this.yPos);
        bb.putFloat(this.zPos);
        bb.putFloat(this.xRotate);
        bb.putFloat(this.yRotate);
        bb.putFloat(this.zRotate);
        return bb.array();
    }

    @Override
    public void setValueByString(String value) {
        String[] subExpressions = value.split("#");
        if (subExpressions.length != 6) {
            throw new IllegalArgumentException("The passed position data must contain 6 positions separated by #");
        }
        HashMap<String, Float> variables = new HashMap<String, Float>();
        variables.put("xPos", Float.valueOf(this.xPos));
        variables.put("yPos", Float.valueOf(this.yPos));
        variables.put("zPos", Float.valueOf(this.zPos));
        variables.put("xRotate", Float.valueOf(this.xRotate));
        variables.put("yRotate", Float.valueOf(this.yRotate));
        variables.put("zRotate", Float.valueOf(this.zRotate));
        this.xPos = ModelFunctions.evaluateMathematicalExpression(subExpressions[0], variables);
        this.yPos = ModelFunctions.evaluateMathematicalExpression(subExpressions[1], variables);
        this.zPos = ModelFunctions.evaluateMathematicalExpression(subExpressions[2], variables);
        this.xRotate = ModelFunctions.evaluateMathematicalExpression(subExpressions[3], variables);
        this.yRotate = ModelFunctions.evaluateMathematicalExpression(subExpressions[4], variables);
        this.zRotate = ModelFunctions.evaluateMathematicalExpression(subExpressions[5], variables);
    }

    @Override
    public String getValueAsString() {
        StringBuilder sb = new StringBuilder();
        sb.append(ModelFunctions.formatFloatNumber(this.xPos, 3));
        sb.append(';');
        sb.append(ModelFunctions.formatFloatNumber(this.yPos, 3));
        sb.append(';');
        sb.append(ModelFunctions.formatFloatNumber(this.zPos, 3));
        sb.append(';');
        sb.append(ModelFunctions.formatFloatNumber(this.xRotate, 3));
        sb.append(';');
        sb.append(ModelFunctions.formatFloatNumber(this.yRotate, 3));
        sb.append(';');
        sb.append(ModelFunctions.formatFloatNumber(this.zRotate, 3));
        return sb.toString();
    }

    public float getxPos() {
        return this.xPos;
    }

    public void setxPos(float xPos) {
        this.xPos = xPos;
    }

    public float getyPos() {
        return this.yPos;
    }

    public void setyPos(float yPos) {
        this.yPos = yPos;
    }

    public float getzPos() {
        return this.zPos;
    }

    public void setzPos(float zPos) {
        this.zPos = zPos;
    }

    public float getxRotate() {
        return this.xRotate;
    }

    public void setxRotate(float xRotate) {
        this.xRotate = xRotate;
    }

    public float getyRotate() {
        return this.yRotate;
    }

    public void setyRotate(float yRotate) {
        this.yRotate = yRotate;
    }

    public float getzRotate() {
        return this.zRotate;
    }

    public void setzRotate(float zRotate) {
        this.zRotate = zRotate;
    }
}

