/*
 * Decompiled with CFR 0.152.
 */
package model.subrecorddata;

import java.util.HashMap;
import model.ModelFunctions;
import model.subrecorddata.SubRecordData;

public class SubRecordDataLong
implements SubRecordData {
    private long value;
    private String key;

    public SubRecordDataLong(byte[] bytes, String key) {
        this.value = ModelFunctions.getLongFromBytes(bytes);
        this.key = key;
    }

    public SubRecordDataLong(int value, String key) {
        this.value = value;
        this.key = key;
    }

    @Override
    public byte[] getRawData() {
        return ModelFunctions.getBytesFromLong(this.value);
    }

    @Override
    public void setValueByString(String stringValue) {
        HashMap<String, Double> variables = new HashMap<String, Double>();
        variables.put(this.key, new Double(this.value));
        this.value = Math.round(ModelFunctions.evaluateMathematicalExpressionDouble(stringValue, variables));
    }

    @Override
    public String getValueAsString() {
        return String.valueOf(this.value);
    }

    public long getValue() {
        return this.value;
    }

    public void setValue(int value) {
        this.value = value;
    }
}

