/*
 * Decompiled with CFR 0.152.
 */
package model.subrecorddata;

import java.util.HashMap;
import model.ModelFunctions;
import model.subrecorddata.SubRecordData;

public class SubRecordDataInt
implements SubRecordData {
    private int value;
    private String key;

    public SubRecordDataInt(byte[] bytes, String key) {
        this.value = ModelFunctions.getIntFromBytes(bytes);
        this.key = key;
    }

    public SubRecordDataInt(int value, String key) {
        this.value = value;
        this.key = key;
    }

    @Override
    public byte[] getRawData() {
        return ModelFunctions.getBytesFromInt(this.value);
    }

    @Override
    public void setValueByString(String stringValue) {
        HashMap<String, Float> variables = new HashMap<String, Float>();
        variables.put(this.key, new Float(this.value));
        this.value = Math.round(ModelFunctions.evaluateMathematicalExpression(stringValue, variables));
    }

    @Override
    public String getValueAsString() {
        return String.valueOf(this.value);
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int value) {
        this.value = value;
    }
}

