/*
 * Decompiled with CFR 0.152.
 */
package model.subrecorddata;

import java.util.HashMap;
import model.ModelFunctions;
import model.subrecorddata.SubRecordData;

public class SubRecordDataFloat
implements SubRecordData {
    private float value;
    private String key;
    private int refractionDigits;

    public SubRecordDataFloat(byte[] bytes, String key, int refractionDigits) {
        this.value = ModelFunctions.getFloatFromBytes(bytes);
        this.key = key;
        this.refractionDigits = refractionDigits;
    }

    public SubRecordDataFloat(float value, String key, int refractionDigits) {
        this.value = value;
        this.key = key;
        this.refractionDigits = refractionDigits;
    }

    public float getValue() {
        return this.value;
    }

    public void setValue(float value) {
        this.value = value;
    }

    @Override
    public byte[] getRawData() {
        return ModelFunctions.getBytesFromFloat(this.value);
    }

    @Override
    public void setValueByString(String stringValue) {
        HashMap<String, Float> variables = new HashMap<String, Float>();
        variables.put(this.key, Float.valueOf(this.value));
        this.value = ModelFunctions.evaluateMathematicalExpression(stringValue, variables);
    }

    @Override
    public String getValueAsString() {
        return ModelFunctions.formatFloatNumber(this.value, this.refractionDigits);
    }
}

