/*
 * Decompiled with CFR 0.152.
 */
package model.subrecorddata;

import java.nio.ByteBuffer;
import java.util.HashMap;
import model.ModelFunctions;
import model.subrecorddata.SubRecordData;

public class SubRecordDataComposed
implements SubRecordData {
    private Type[] types;
    private String[] variables;
    private Object[] values;
    private int length;

    public SubRecordDataComposed(byte[] bytes, Type[] types, String[] variables) {
        this.types = types;
        this.variables = variables;
        this.values = new Object[types.length];
        this.length = bytes.length;
        ByteBuffer bb = ModelFunctions.getByteBufferFromBytes(bytes);
        int i = 0;
        while (i < types.length) {
            switch (types[i]) {
                case Byte: {
                    this.values[i] = new Byte(bb.get());
                    break;
                }
                case Short: {
                    this.values[i] = new Short(bb.getShort());
                    break;
                }
                case Integer: {
                    this.values[i] = new Integer(bb.getInt());
                    break;
                }
                default: {
                    this.values[i] = new Float(bb.getFloat());
                }
            }
            ++i;
        }
    }

    @Override
    public byte[] getRawData() {
        ByteBuffer bb = ModelFunctions.getByteBufferToFill(this.length);
        int i = 0;
        while (i < this.values.length) {
            switch (this.types[i]) {
                case Byte: {
                    bb.put((Byte)this.values[i]);
                    break;
                }
                case Short: {
                    bb.putShort((Short)this.values[i]);
                    break;
                }
                case Integer: {
                    bb.putInt((Integer)this.values[i]);
                    break;
                }
                default: {
                    bb.putFloat(((Float)this.values[i]).floatValue());
                }
            }
            ++i;
        }
        return bb.array();
    }

    public void setValueByStringFor(String stringValue, String variable) {
        int index = this.getIndexOf(variable);
        if (index == -1) {
            throw new IllegalArgumentException(String.valueOf(variable) + " is not a variable in this subrecord.");
        }
        float currentValue = this.getNumberValueOf(this.values[index]);
        HashMap<String, Float> variables = new HashMap<String, Float>();
        variables.put(variable, Float.valueOf(currentValue));
        float newValue = ModelFunctions.evaluateMathematicalExpression(stringValue, variables);
        this.setValueAt(index, newValue);
    }

    public String getValueAsStringOf(String variable) {
        int index = this.getIndexOf(variable);
        if (index == -1) {
            throw new IllegalArgumentException(String.valueOf(variable) + " is not a variable in this subrecord.");
        }
        float currentValue = this.getNumberValueOf(this.values[index]);
        switch (this.types[index]) {
            case Byte: 
            case Short: 
            case Integer: {
                return String.valueOf(Math.round(currentValue));
            }
        }
        return ModelFunctions.formatFloatNumber(currentValue, 3);
    }

    @Override
    public void setValueByString(String stringValue) {
        String[] splitValues = stringValue.split(";");
        if (splitValues.length != this.variables.length) {
            throw new IllegalArgumentException("The passed value cannot be split into the correct amount of subvalues.");
        }
        int i = 0;
        while (i < this.variables.length) {
            this.setValueByStringFor(splitValues[i], this.variables[i]);
            ++i;
        }
    }

    @Override
    public String getValueAsString() {
        StringBuilder sB = new StringBuilder();
        int i = 0;
        while (i < this.variables.length) {
            sB.append(this.getValueAsStringOf(this.variables[i]));
            if (i < this.variables.length - 1) {
                sB.append(';');
            }
            ++i;
        }
        return sB.toString();
    }

    private void setValueAt(int i, float newValue) {
        switch (this.types[i]) {
            case Byte: {
                this.values[i] = new Byte((byte)Math.round(newValue));
                break;
            }
            case Short: {
                this.values[i] = new Short((short)Math.round(newValue));
                break;
            }
            case Integer: {
                this.values[i] = new Integer(Math.round(newValue));
                break;
            }
            default: {
                this.values[i] = new Float(newValue);
            }
        }
    }

    private float getNumberValueOf(Object o) {
        if (o instanceof Byte) {
            return ((Byte)o).byteValue();
        }
        if (o instanceof Short) {
            return ((Short)o).shortValue();
        }
        if (o instanceof Integer) {
            return ((Integer)o).intValue();
        }
        return ((Float)o).floatValue();
    }

    private int getIndexOf(String variable) {
        int i = 0;
        while (i < this.variables.length) {
            if (this.variables[i].equals(variable)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static enum Type {
        Byte,
        Short,
        Integer,
        Float;

    }
}

