/*
 * Decompiled with CFR 0.152.
 */
package model.subrecorddata;

import java.util.HashMap;
import model.ModelFunctions;
import model.subrecorddata.SubRecordData;

public class SubRecordDataByte
implements SubRecordData {
    private byte value;
    private String key;

    public SubRecordDataByte(byte[] bytes, String key) {
        if (bytes.length != 1) {
            throw new IllegalArgumentException("The passed bytes array must only contain a single byte.");
        }
        this.key = key;
        this.value = bytes[0];
    }

    public SubRecordDataByte(byte value, String key) {
        this.key = key;
        this.value = value;
    }

    @Override
    public byte[] getRawData() {
        return new byte[]{this.value};
    }

    @Override
    public void setValueByString(String stringValue) {
        HashMap<String, Float> variables = new HashMap<String, Float>();
        variables.put(this.key, new Float(this.value));
        this.value = (byte)ModelFunctions.evaluateMathematicalExpression(stringValue, variables);
    }

    @Override
    public String getValueAsString() {
        return String.valueOf(this.value);
    }
}

