/*
 * Decompiled with CFR 0.152.
 */
package model;

import java.io.UnsupportedEncodingException;
import model.ModelFunctions;
import model.Record;
import model.subrecorddata.SubRecordData;
import model.subrecorddata.SubRecordDataByte;
import model.subrecorddata.SubRecordDataComposed;
import model.subrecorddata.SubRecordDataFloat;
import model.subrecorddata.SubRecordDataInt;
import model.subrecorddata.SubRecordDataLong;
import model.subrecorddata.SubRecordDataObjectCoordinates;
import model.subrecorddata.SubRecordDataSCVR;
import model.subrecorddata.SubRecordDataShort;
import model.subrecorddata.SubRecordDataString;
import model.subrecorddata.SubRecordDataUnknown;
import model.subrecorddata.SubrecordDataFactionMembership;
import model.subrecorddata.SubrecordDataNPCO;
import model.subrecorddata.SubrecordDataNPDT;
import model.subrecorddata.SubrecordDataSPDT;
import model.subrecorddata.SubrecordDataVFXMEntry;

public class SubRecord {
    protected Record parentRecord;
    protected String name;
    protected SubRecordData data;

    public SubRecord(String name, byte[] subrecordDataBytes, Record parentRecord) throws UnsupportedEncodingException {
        this.name = name;
        this.parentRecord = parentRecord;
        this.readSubRecordData(subrecordDataBytes);
    }

    public SubRecord(String name, SubRecordData data, Record parentRecord) {
        this.name = name;
        this.data = data;
        this.parentRecord = parentRecord;
    }

    public String getName() {
        return this.name;
    }

    public SubRecordData getData() {
        return this.data;
    }

    public byte[] getRawData() {
        byte[] subRawData = this.data.getRawData();
        byte[] rawData = new byte[subRawData.length + 8];
        System.arraycopy(ModelFunctions.getBytesFromString(this.name), 0, rawData, 0, 4);
        System.arraycopy(ModelFunctions.getBytesFromInt(subRawData.length), 0, rawData, 4, 4);
        System.arraycopy(subRawData, 0, rawData, 8, subRawData.length);
        return rawData;
    }

    protected void readSubRecordData(byte[] subrecordDataBytes) throws UnsupportedEncodingException {
        if (this.parentRecord.getName().equals("CELL")) {
            this.data = this.name.equals("XSCL") ? new SubRecordDataFloat(subrecordDataBytes, "scale", 2) : (this.name.equals("NAME") ? new SubRecordDataString(subrecordDataBytes, "id", 1, 50) : (this.name.equals("DATA") || this.name.equals("DODT") ? new SubRecordDataObjectCoordinates(subrecordDataBytes) : (this.name.equals("FRMR") ? new SubRecordDataInt(subrecordDataBytes, "index") : (this.name.equals("XSOL") ? new SubRecordDataString(subrecordDataBytes, "creature", 1, 32) : (this.name.equals("ANAM") ? new SubRecordDataString(subrecordDataBytes, "creature", 1, 32) : (this.name.equals("TNAM") ? new SubRecordDataString(subrecordDataBytes, "spell", 1, 32) : (this.name.equals("KNAM") ? new SubRecordDataString(subrecordDataBytes, "item", 1, 32) : (this.name.equals("CNAM") ? new SubRecordDataString(subrecordDataBytes, "faction", 1, 50) : new SubRecordDataUnknown(subrecordDataBytes)))))))));
            return;
        }
        if (this.parentRecord.getName().equals("REFR")) {
            if (this.name.equals("TGTN")) {
                this.data = new SubRecordDataString(subrecordDataBytes, "creature", 1, 32);
                return;
            }
            if (this.name.equals("WNAM")) {
                this.data = new SubRecordDataString(subrecordDataBytes, "spell", 1, 32);
                return;
            }
        }
        if (this.parentRecord.getName().equals("STLN")) {
            this.data = this.name.equals("ONAM") ? new SubRecordDataString(subrecordDataBytes, "creature", 1, 32) : (this.name.equals("FNAM") ? new SubRecordDataString(subrecordDataBytes, "faction", 1, 50) : (this.name.equals("NAME") ? new SubRecordDataString(subrecordDataBytes, "item", 1, 32) : new SubRecordDataUnknown(subrecordDataBytes)));
            return;
        }
        if (this.parentRecord.getName().equals("SCPT")) {
            this.data = this.name.equals("SCTX") ? new SubRecordDataString(subrecordDataBytes, "text", 1, 99999, false) : new SubRecordDataUnknown(subrecordDataBytes);
            return;
        }
        if (this.parentRecord.getName().equals("LAND")) {
            this.data = this.name.equals("INTV") ? new SubRecordDataComposed(subrecordDataBytes, new SubRecordDataComposed.Type[]{SubRecordDataComposed.Type.Integer, SubRecordDataComposed.Type.Integer}, new String[]{"gridX", "gridY"}) : new SubRecordDataUnknown(subrecordDataBytes);
            return;
        }
        if (this.parentRecord.getName().equals("FACT") && this.name.equals("ANAM")) {
            this.data = new SubRecordDataString(subrecordDataBytes, "faction", 1, 50, false);
            return;
        }
        if (this.parentRecord.getName().equals("TES3")) {
            this.data = this.name.equals("MAST") ? new SubRecordDataString(subrecordDataBytes, "name", 1, 99999) : (this.name.equals("DATA") ? new SubRecordDataLong(subrecordDataBytes, "size") : new SubRecordDataUnknown(subrecordDataBytes));
            return;
        }
        if (this.parentRecord.getName().equals("INFO")) {
            this.data = this.name.equals("INAM") ? new SubRecordDataString(subrecordDataBytes, "id", 0, 100) : (this.name.equals("PNAM") ? new SubRecordDataString(subrecordDataBytes, "previousResponseId", 0, 100) : (this.name.equals("NNAM") ? new SubRecordDataString(subrecordDataBytes, "followingResponseId", 0, 100) : (this.name.equals("DATA") ? new SubRecordDataComposed(subrecordDataBytes, new SubRecordDataComposed.Type[]{SubRecordDataComposed.Type.Integer, SubRecordDataComposed.Type.Integer, SubRecordDataComposed.Type.Byte, SubRecordDataComposed.Type.Byte, SubRecordDataComposed.Type.Byte, SubRecordDataComposed.Type.Byte}, new String[]{"?1", "disposition", "rank", "gender", "playersRank", "?2"}) : (this.name.equals("ONAM") ? new SubRecordDataString(subrecordDataBytes, "npc", 0, 32) : (this.name.equals("RNAM") ? new SubRecordDataString(subrecordDataBytes, "race", 0, 100) : (this.name.equals("CNAM") ? new SubRecordDataString(subrecordDataBytes, "class", 0, 100) : (this.name.equals("FNAM") ? new SubRecordDataString(subrecordDataBytes, "faction", 0, 100) : (this.name.equals("ANAM") ? new SubRecordDataString(subrecordDataBytes, "cell", 0, 100) : (this.name.equals("DNAM") ? new SubRecordDataString(subrecordDataBytes, "playersFaction", 0, 100) : (this.name.equals("NAME") ? new SubRecordDataString(subrecordDataBytes, "text", 0, 512, false) : (this.name.equals("SNAM") ? new SubRecordDataString(subrecordDataBytes, "sound", 0, 100) : (this.name.equals("QSTN") ? new SubRecordDataByte(subrecordDataBytes, "journalName") : (this.name.equals("QSTF") ? new SubRecordDataByte(subrecordDataBytes, "journalFinish") : (this.name.equals("QSTR") ? new SubRecordDataByte(subrecordDataBytes, "journalRestart") : (this.name.equals("FLTV") ? new SubRecordDataFloat(subrecordDataBytes, "targetValue", 3) : (this.name.equals("INTV") ? new SubRecordDataInt(subrecordDataBytes, "targetValue") : (this.name.equals("BNAM") ? new SubRecordDataString(subrecordDataBytes, "resultText", 0, 9999, false) : (this.name.equals("SCVR") ? new SubRecordDataSCVR(subrecordDataBytes) : new SubRecordDataUnknown(subrecordDataBytes)))))))))))))))))));
            return;
        }
        if (this.parentRecord.getName().equals("DOOR") && (this.name.equals("SNAM") || this.name.equals("ANAM"))) {
            this.data = new SubRecordDataString(subrecordDataBytes, "sound", 0, 100);
            return;
        }
        if (this.parentRecord.getName().equals("REGN")) {
            if (this.name.equals("SNAM")) {
                this.data = new SubRecordDataUnknown(subrecordDataBytes);
                return;
            }
            if (this.name.equals("BNAM")) {
                this.data = new SubRecordDataString(subrecordDataBytes, "creature", 0, 32);
                return;
            }
        }
        if (this.parentRecord.getName().equals("ARMO")) {
            if (this.name.equals("BNAM") || this.name.equals("CNAM")) {
                this.data = new SubRecordDataString(subrecordDataBytes, "bodypart", 0, 32, false);
                return;
            }
            if (this.name.equals("ENAM")) {
                this.data = new SubRecordDataString(subrecordDataBytes, "enchantment", 0, 32);
                return;
            }
        }
        if (this.parentRecord.getName().equals("CLOT")) {
            if (this.name.equals("BNAM") || this.name.equals("CNAM")) {
                this.data = new SubRecordDataString(subrecordDataBytes, "bodypart", 0, 32, false);
                return;
            }
            if (this.name.equals("ENAM")) {
                this.data = new SubRecordDataString(subrecordDataBytes, "enchantment", 0, 32);
                return;
            }
        }
        if (this.parentRecord.getName().equals("WEAP") && this.name.equals("ENAM")) {
            this.data = new SubRecordDataString(subrecordDataBytes, "enchantment", 0, 32);
            return;
        }
        if (this.parentRecord.getName().equals("BOOK") && this.name.equals("ENAM")) {
            this.data = new SubRecordDataString(subrecordDataBytes, "enchantment", 0, 32);
            return;
        }
        if (this.parentRecord.getName().equals("LEVI")) {
            if (this.name.equals("INAM")) {
                this.data = new SubRecordDataString(subrecordDataBytes, "item", 0, 32);
                return;
            }
            if (this.name.equals("INTV")) {
                this.data = new SubRecordDataShort(subrecordDataBytes, "number");
                return;
            }
        }
        if (this.parentRecord.getName().equals("LEVC")) {
            if (this.name.equals("CNAM")) {
                this.data = new SubRecordDataString(subrecordDataBytes, "creature", 0, 32);
                return;
            }
            if (this.name.equals("INTV")) {
                this.data = new SubRecordDataShort(subrecordDataBytes, "level");
                return;
            }
        }
        if (this.parentRecord.getName().equals("SNDG")) {
            if (this.name.equals("CNAM")) {
                this.data = new SubRecordDataString(subrecordDataBytes, "creature", 0, 32);
                return;
            }
            if (this.name.equals("DATA")) {
                this.data = new SubRecordDataInt(subrecordDataBytes, "soundType");
                return;
            }
        }
        if (this.parentRecord.getName().equals("CREA") && this.name.equals("CNAM")) {
            this.data = new SubRecordDataString(subrecordDataBytes, "creature", 0, 32);
            return;
        }
        if (this.parentRecord.getName().equals("LTEX") && this.name.equals("DATA")) {
            this.data = new SubRecordDataString(subrecordDataBytes, "file", 0, 100);
            return;
        }
        if (this.parentRecord.getName().equals("SOUN") && this.name.equals("FNAM")) {
            this.data = new SubRecordDataString(subrecordDataBytes, "file", 0, 100);
            return;
        }
        if (this.parentRecord.getName().equals("NPC_")) {
            if (this.name.equals("ANAM")) {
                this.data = new SubRecordDataString(subrecordDataBytes, "faction", 0, 100);
                return;
            }
            if (this.name.equals("CNAM")) {
                this.data = new SubRecordDataString(subrecordDataBytes, "class", 0, 100);
                return;
            }
            if (this.name.equals("BNAM")) {
                this.data = new SubRecordDataString(subrecordDataBytes, "bodypart", 0, 32);
                return;
            }
            if (this.name.equals("KNAM")) {
                this.data = new SubRecordDataString(subrecordDataBytes, "bodypart", 0, 32);
                return;
            }
        }
        if (this.parentRecord.getName().equals("SPLM")) {
            if (this.name.equals("SPDT")) {
                this.data = new SubrecordDataSPDT(subrecordDataBytes);
                return;
            }
            if (this.name.equals("NPDT")) {
                this.data = new SubrecordDataNPDT(subrecordDataBytes);
                return;
            }
            this.data = new SubRecordDataUnknown(subrecordDataBytes);
            return;
        }
        if (this.parentRecord.getName().equals("VFXM")) {
            if (this.name.equals("VNAM")) {
                this.data = new SubrecordDataVFXMEntry(subrecordDataBytes);
                return;
            }
            this.data = new SubRecordDataUnknown(subrecordDataBytes);
            return;
        }
        if (this.parentRecord.getName().equals("PCDT")) {
            if (this.name.equals("FNAM")) {
                this.data = new SubrecordDataFactionMembership(subrecordDataBytes);
                return;
            }
            if (this.name.equals("NAM0") || this.name.equals("NAM1") || this.name.equals("NAM2") || this.name.equals("NAM3")) {
                this.data = new SubRecordDataString(subrecordDataBytes, "item", 1, 32);
                return;
            }
        }
        if (this.parentRecord.getName().equals("CNTC") && this.name.equals("XSOL")) {
            this.data = new SubRecordDataString(subrecordDataBytes, "creature", 1, 32);
            return;
        }
        if (this.parentRecord.getName().equals("KLST") && this.name.equals("KNAM")) {
            this.data = new SubRecordDataString(subrecordDataBytes, "creature", 1, 32);
            return;
        }
        if (this.name.equals("NAME")) {
            this.data = new SubRecordDataString(subrecordDataBytes, "id", 0, 100, true, true);
            return;
        }
        if (this.name.equals("SCRI")) {
            this.data = new SubRecordDataString(subrecordDataBytes, "script", 0, 100);
            return;
        }
        if (this.name.equals("SNAM")) {
            this.data = new SubRecordDataString(subrecordDataBytes, "sound", 0, 100);
            return;
        }
        if (this.name.equals("NPCO")) {
            this.data = new SubrecordDataNPCO(subrecordDataBytes);
            return;
        }
        if (this.name.equals("MODL")) {
            this.data = new SubRecordDataString(subrecordDataBytes, "file", 0, 100);
            return;
        }
        if (this.name.equals("ITEX")) {
            this.data = new SubRecordDataString(subrecordDataBytes, "file", 0, 100);
            return;
        }
        if (this.name.equals("NPCS")) {
            this.data = new SubRecordDataString(subrecordDataBytes, "spell", 0, 32);
            return;
        }
        this.data = new SubRecordDataUnknown(subrecordDataBytes);
    }
}

