/*
 * Decompiled with CFR 0.152.
 */
package model;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import model.ModelFunctions;
import model.Record;
import model.SubRecord;
import model.SubRecordCellDef;

class RecordCell
extends Record {
    private boolean referencesStarted = false;

    public RecordCell(String name, int header, int flags, byte[] subRecordBytes) throws UnsupportedEncodingException {
        super(name, header, flags, subRecordBytes);
    }

    @Override
    protected void readNextSubRecord(ByteBuffer byteBuffer) throws UnsupportedEncodingException {
        String subRecordName = ModelFunctions.getNextRecordNameFromByteBuffer(byteBuffer);
        int recordSize = byteBuffer.getInt();
        byte[] subRecordDataBytes = new byte[recordSize];
        byteBuffer.get(subRecordDataBytes);
        if (!this.referencesStarted && subRecordName.equals("FRMR")) {
            this.referencesStarted = true;
        }
        if (!this.referencesStarted) {
            this.subRecords.add(new SubRecordCellDef(subRecordName, subRecordDataBytes, (Record)this));
        } else {
            this.subRecords.add(new SubRecord(subRecordName, subRecordDataBytes, (Record)this));
        }
    }
}

