/*
 * Decompiled with CFR 0.152.
 */
package model;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import model.ModelFunctions;
import model.SubRecord;

public class Record {
    private String name;
    private int header;
    private int flags;
    protected List<SubRecord> subRecords;

    public Record(String name, int header, int flags, byte[] subRecordBytes) throws UnsupportedEncodingException {
        this.name = name;
        this.header = header;
        this.flags = flags;
        this.subRecords = new ArrayList<SubRecord>();
        this.readSubrecordsFromBytes(subRecordBytes);
    }

    public String getName() {
        return this.name;
    }

    public int getHeader() {
        return this.header;
    }

    public int getFlags() {
        return this.flags;
    }

    public List<SubRecord> getSubRecords() {
        return this.subRecords;
    }

    public byte[] getRawData() {
        LinkedList<byte[]> rawDataChunks = new LinkedList<byte[]>();
        int size = 0;
        for (SubRecord subRecord : this.subRecords) {
            byte[] rawData = subRecord.getRawData();
            size += rawData.length;
            rawDataChunks.add(rawData);
        }
        byte[] returnRawData = new byte[size + 16];
        System.arraycopy(ModelFunctions.getBytesFromString(this.name), 0, returnRawData, 0, 4);
        System.arraycopy(ModelFunctions.getBytesFromInt(size), 0, returnRawData, 4, 4);
        System.arraycopy(ModelFunctions.getBytesFromInt(this.header), 0, returnRawData, 8, 4);
        System.arraycopy(ModelFunctions.getBytesFromInt(this.flags), 0, returnRawData, 12, 4);
        int startPosition = 16;
        for (byte[] rawDataChunk : rawDataChunks) {
            System.arraycopy(rawDataChunk, 0, returnRawData, startPosition, rawDataChunk.length);
            startPosition += rawDataChunk.length;
        }
        return returnRawData;
    }

    protected void readSubrecordsFromBytes(byte[] subRecordBytes) throws UnsupportedEncodingException {
        ByteBuffer byteBuffer = ModelFunctions.getByteBufferFromBytes(subRecordBytes);
        while (byteBuffer.hasRemaining()) {
            this.readNextSubRecord(byteBuffer);
        }
    }

    protected void readNextSubRecord(ByteBuffer byteBuffer) throws UnsupportedEncodingException {
        String subRecordName = ModelFunctions.getNextRecordNameFromByteBuffer(byteBuffer);
        int recordSize = byteBuffer.getInt();
        byte[] subRecordDataBytes = new byte[recordSize];
        byteBuffer.get(subRecordDataBytes);
        this.subRecords.add(new SubRecord(subRecordName, subRecordDataBytes, this));
    }
}

