/*
 * Decompiled with CFR 0.152.
 */
package database.where;

import database.Columns;
import database.Row;
import database.where.Comparison;
import java.util.HashMap;
import model.ModelFunctions;

public class SingleComparison
implements Comparison {
    private String leftExpression;
    private String rightExpression;
    private Operation operation;

    public SingleComparison(String leftExpression, String rightExpression, Operation operation) {
        this.leftExpression = leftExpression;
        this.rightExpression = rightExpression;
        this.operation = operation;
    }

    @Override
    public boolean testConditionOnRow(Row row) {
        Columns columns = row.getColumns();
        String[] columnNames = columns.getColumnNames();
        if (ModelFunctions.isNumberExpression(this.leftExpression, columns) && ModelFunctions.isNumberExpression(this.rightExpression, columns)) {
            HashMap<String, Float> variables = new HashMap<String, Float>();
            int i = 0;
            while (i < columnNames.length) {
                if (row.isNumeric(columnNames[i])) {
                    variables.put(columnNames[i], Float.valueOf(Float.parseFloat(row.getValueOf(columnNames[i]))));
                }
                ++i;
            }
            float leftExpressionResult = ModelFunctions.evaluateMathematicalExpression(this.leftExpression, variables);
            float rightExpressionResult = ModelFunctions.evaluateMathematicalExpression(this.rightExpression, variables);
            return this.comparisonResult(leftExpressionResult, rightExpressionResult);
        }
        if (ModelFunctions.isStringExpression(this.leftExpression, columns) && ModelFunctions.isStringExpression(this.rightExpression, columns)) {
            HashMap<String, String> variables = new HashMap<String, String>();
            int i = 0;
            while (i < columnNames.length) {
                if (!row.isNumeric(columnNames[i])) {
                    variables.put(columnNames[i], row.getValueOf(columnNames[i]));
                }
                ++i;
            }
            String leftExpressionResult = ModelFunctions.evaluateStringExpression(this.leftExpression, variables);
            String rightExpressionResult = ModelFunctions.evaluateStringExpression(this.rightExpression, variables);
            if (this.operation == Operation.equals) {
                if (rightExpressionResult.startsWith("%")) {
                    if (rightExpressionResult.endsWith("%")) {
                        this.operation = Operation.contains;
                        rightExpressionResult = rightExpressionResult.substring(1, rightExpressionResult.length() - 1);
                    } else {
                        this.operation = Operation.endswith;
                        rightExpressionResult = rightExpressionResult.substring(1);
                    }
                } else if (rightExpressionResult.endsWith("%")) {
                    this.operation = Operation.startswith;
                    rightExpressionResult = rightExpressionResult.substring(0, rightExpressionResult.length() - 1);
                }
                boolean comparisonResult = this.comparisonResult(leftExpressionResult, rightExpressionResult);
                this.operation = Operation.equals;
                return comparisonResult;
            }
            if (this.operation == Operation.unequals) {
                if (rightExpressionResult.startsWith("%")) {
                    if (rightExpressionResult.endsWith("%")) {
                        this.operation = Operation.notcontains;
                        rightExpressionResult = rightExpressionResult.substring(1, rightExpressionResult.length() - 1);
                    } else {
                        this.operation = Operation.notendswith;
                        rightExpressionResult = rightExpressionResult.substring(1);
                    }
                } else if (rightExpressionResult.endsWith("%")) {
                    this.operation = Operation.notstartswith;
                    rightExpressionResult = rightExpressionResult.substring(0, rightExpressionResult.length() - 1);
                }
                boolean comparisonResult = this.comparisonResult(leftExpressionResult, rightExpressionResult);
                this.operation = Operation.unequals;
                return comparisonResult;
            }
            return this.comparisonResult(leftExpressionResult, rightExpressionResult);
        }
        System.out.println("The expressions " + this.leftExpression + " and " + this.rightExpression + " need to be both string or number expressions. No comparison possible.");
        return false;
    }

    public boolean comparisonResult(double leftExpressionResult, double rightExpressionResult) {
        switch (this.operation) {
            case equals: {
                return leftExpressionResult == rightExpressionResult;
            }
            case unequals: {
                return leftExpressionResult != rightExpressionResult;
            }
            case greaterthan: {
                return leftExpressionResult > rightExpressionResult;
            }
            case greaterthanorequals: {
                return leftExpressionResult >= rightExpressionResult;
            }
            case lessthan: {
                return leftExpressionResult < rightExpressionResult;
            }
            case lessthanorequals: {
                return leftExpressionResult <= rightExpressionResult;
            }
        }
        return false;
    }

    public boolean comparisonResult(String leftExpressionResult, String rightExpressionResult) {
        switch (this.operation) {
            case equals: {
                return leftExpressionResult.trim().equalsIgnoreCase(rightExpressionResult.trim());
            }
            case unequals: {
                return !leftExpressionResult.trim().equalsIgnoreCase(rightExpressionResult.trim());
            }
            case greaterthan: {
                return leftExpressionResult.trim().compareToIgnoreCase(rightExpressionResult.trim()) > 0;
            }
            case greaterthanorequals: {
                return leftExpressionResult.trim().compareToIgnoreCase(rightExpressionResult.trim()) >= 0;
            }
            case lessthan: {
                return leftExpressionResult.trim().compareToIgnoreCase(rightExpressionResult.trim()) < 0;
            }
            case lessthanorequals: {
                return leftExpressionResult.trim().compareToIgnoreCase(rightExpressionResult.trim()) <= 0;
            }
            case contains: {
                return leftExpressionResult.trim().toLowerCase().contains(rightExpressionResult.trim().toLowerCase());
            }
            case startswith: {
                return leftExpressionResult.trim().toLowerCase().startsWith(rightExpressionResult.trim().toLowerCase());
            }
            case endswith: {
                return leftExpressionResult.trim().toLowerCase().endsWith(rightExpressionResult.trim().toLowerCase());
            }
            case notcontains: {
                return !leftExpressionResult.trim().toLowerCase().contains(rightExpressionResult.trim().toLowerCase());
            }
            case notstartswith: {
                return !leftExpressionResult.trim().toLowerCase().startsWith(rightExpressionResult.trim().toLowerCase());
            }
            case notendswith: {
                return !leftExpressionResult.trim().toLowerCase().endsWith(rightExpressionResult.trim().toLowerCase());
            }
        }
        return false;
    }

    public String getLeftExpression() {
        return this.leftExpression;
    }

    public String getRightExpression() {
        return this.rightExpression;
    }

    public Operation getOperation() {
        return this.operation;
    }

    public static enum Operation {
        equals,
        unequals,
        greaterthan,
        greaterthanorequals,
        lessthan,
        lessthanorequals,
        contains,
        startswith,
        endswith,
        notcontains,
        notstartswith,
        notendswith;

    }
}

