/*
 * Decompiled with CFR 0.152.
 */
package database.table;

import database.Columns;
import database.Row;
import database.table.Table;
import database.where.Comparison;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import model.Record;
import model.SubRecord;

public class SpellReferencesTable
extends Table {
    protected Columns allColumns;

    public SpellReferencesTable() {
        boolean[] blArray = new boolean[3];
        blArray[1] = true;
        this.allColumns = new Columns(new String[]{"owningObject", "spell", "type"}, new Columns.Type[]{Columns.Type.text, Columns.Type.text, Columns.Type.text}, blArray);
    }

    @Override
    public List<Row> insert(List<Record> records, List<Row> rows) {
        System.out.println("This table does not support insertion.");
        return null;
    }

    @Override
    public List<Row> select(List<Record> records, Columns selectedColumns, Comparison whereComparison) {
        return this.executeRUD(records, selectedColumns, whereComparison, null, false);
    }

    @Override
    public List<Row> update(List<Record> records, Comparison whereComparison, Map<String, String> updateValues) {
        return this.executeRUD(records, this.allColumns, whereComparison, updateValues, false);
    }

    @Override
    public List<Row> delete(List<Record> records, Comparison whereComparison) {
        return this.executeRUD(records, this.allColumns, whereComparison, null, true);
    }

    private List<Row> executeRUD(List<Record> records, Columns selectedColumns, Comparison whereComparison, Map<String, String> updateValues, boolean delete) {
        ArrayList<Row> returnRows = new ArrayList<Row>();
        int i1 = 0;
        while (i1 < records.size()) {
            Record record = records.get(i1);
            if (record.getName().equals("NPC_") || record.getName().equals("CREA") || record.getName().equals("CELL") || record.getName().equals("REFR")) {
                String owningObject = null;
                int i2 = 0;
                while (i2 < record.getSubRecords().size()) {
                    SubRecord subRecord = record.getSubRecords().get(i2);
                    if (subRecord.getName().equals("NAME")) {
                        owningObject = subRecord.getData().getValueAsString();
                    } else if (subRecord.getName().equals("NPCS") || record.getName().equals("CELL") && subRecord.getName().equals("TNAM") || record.getName().equals("REFR") && subRecord.getName().equals("WNAM")) {
                        String[] rowValues = new String[3];
                        rowValues[0] = owningObject;
                        rowValues[1] = subRecord.getData().getValueAsString();
                        if (rowValues[1].contains("\u0000")) {
                            rowValues[1] = rowValues[1].substring(0, rowValues[1].indexOf(0));
                        }
                        rowValues[2] = subRecord.getName().equals("WNAM") ? "readied spell" : (subRecord.getName().equals("NPCS") ? "spell" : "trap");
                        Row newRow = new Row(this.allColumns, rowValues);
                        if (whereComparison.testConditionOnRow(newRow)) {
                            if (updateValues != null && updateValues.containsKey("spell")) {
                                subRecord.getData().setValueByString(updateValues.get("spell"));
                                rowValues[1] = subRecord.getData().getValueAsString();
                                if (rowValues[1].equals("")) {
                                    record.getSubRecords().remove(i2);
                                    --i2;
                                }
                            }
                            if (delete) {
                                record.getSubRecords().remove(i2);
                                --i2;
                            }
                            if (selectedColumns != this.allColumns) {
                                newRow = newRow.createFractionRow(selectedColumns);
                            }
                            returnRows.add(newRow);
                        }
                    }
                    ++i2;
                }
            }
            ++i1;
        }
        return returnRows;
    }

    @Override
    public String getName() {
        return "spellReferences";
    }

    @Override
    public Columns getAllColumns() {
        return this.allColumns;
    }
}

