/*
 * Decompiled with CFR 0.152.
 */
package database.table;

import database.Columns;
import database.Row;
import database.table.Table;
import database.where.Comparison;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import model.ModelFunctions;
import model.Record;
import model.SubRecord;

public class SoundReferencesTable
extends Table {
    protected Columns allColumns;

    public SoundReferencesTable() {
        boolean[] blArray = new boolean[3];
        blArray[1] = true;
        this.allColumns = new Columns(new String[]{"owningObject", "sound", "soundType"}, new Columns.Type[]{Columns.Type.text, Columns.Type.text, Columns.Type.text}, blArray);
    }

    @Override
    public List<Row> insert(List<Record> records, List<Row> rows) {
        System.out.println("This table does not support insertion.");
        return null;
    }

    @Override
    public List<Row> select(List<Record> records, Columns selectedColumns, Comparison whereComparison) {
        return this.executeRUD(records, selectedColumns, whereComparison, null, false);
    }

    @Override
    public List<Row> update(List<Record> records, Comparison whereComparison, Map<String, String> updateValues) {
        return this.executeRUD(records, this.allColumns, whereComparison, updateValues, false);
    }

    @Override
    public List<Row> delete(List<Record> records, Comparison whereComparison) {
        System.out.println("This table does not support deletion.");
        return null;
    }

    private List<Row> executeRUD(List<Record> records, Columns selectedColumns, Comparison whereComparison, Map<String, String> updateValues, boolean delete) {
        ArrayList<Row> returnRows = new ArrayList<Row>();
        int i1 = 0;
        while (i1 < records.size()) {
            block23: {
                Record record = records.get(i1);
                if (!record.getName().equals("SNDG") && !record.getName().equals("DOOR") && !record.getName().equals("LIGH") && !record.getName().equals("REGN")) break block23;
                String[] rowValues = new String[3];
                SubRecord soundSubRecord = null;
                int i2 = 0;
                while (i2 < record.getSubRecords().size()) {
                    block25: {
                        Row newRow;
                        block28: {
                            SubRecord subRecord;
                            block31: {
                                block26: {
                                    block30: {
                                        block29: {
                                            block27: {
                                                block24: {
                                                    subRecord = record.getSubRecords().get(i2);
                                                    if (!subRecord.getName().equals("NAME")) break block24;
                                                    rowValues[0] = subRecord.getData().getValueAsString();
                                                    break block25;
                                                }
                                                if (!subRecord.getName().equals("SNAM")) break block26;
                                                soundSubRecord = subRecord;
                                                if (!record.getName().equals("REGN")) break block27;
                                                rowValues = Arrays.copyOf(rowValues, rowValues.length);
                                                rowValues[1] = ModelFunctions.getStringFromBytes(Arrays.copyOfRange(subRecord.getData().getRawData(), 0, 32));
                                                if (rowValues[1].contains("\u0000")) {
                                                    rowValues[1] = rowValues[1].substring(0, rowValues[1].indexOf(0));
                                                }
                                                rowValues[2] = "regional";
                                                break block28;
                                            }
                                            if (!record.getName().equals("LIGH")) break block29;
                                            rowValues[1] = subRecord.getData().getValueAsString();
                                            rowValues[2] = "light";
                                            break block28;
                                        }
                                        if (!record.getName().equals("DOOR")) break block30;
                                        rowValues = Arrays.copyOf(rowValues, rowValues.length);
                                        rowValues[1] = subRecord.getData().getValueAsString();
                                        rowValues[2] = "doorOpen";
                                        break block28;
                                    }
                                    if (!record.getName().equals("SNDG")) break block25;
                                    rowValues[1] = subRecord.getData().getValueAsString();
                                    break block28;
                                }
                                if (!subRecord.getName().equals("ANAM")) break block31;
                                if (!record.getName().equals("DOOR")) break block25;
                                soundSubRecord = subRecord;
                                rowValues = Arrays.copyOf(rowValues, rowValues.length);
                                rowValues[1] = subRecord.getData().getValueAsString();
                                rowValues[2] = "doorClose";
                                break block28;
                            }
                            if (!subRecord.getName().equals("DATA") || !record.getName().equals("SNDG")) break block25;
                            rowValues = Arrays.copyOf(rowValues, rowValues.length);
                            int soundTypeConstant = Integer.parseInt(subRecord.getData().getValueAsString());
                            switch (soundTypeConstant) {
                                case 0: {
                                    rowValues[2] = "creatureLeftFoot";
                                    break;
                                }
                                case 1: {
                                    rowValues[2] = "creatureRightFoot";
                                    break;
                                }
                                case 2: {
                                    rowValues[2] = "creatureLeftSwim";
                                    break;
                                }
                                case 3: {
                                    rowValues[2] = "creatureRightSwim";
                                    break;
                                }
                                case 4: {
                                    rowValues[2] = "creatureMoan";
                                    break;
                                }
                                case 5: {
                                    rowValues[2] = "creatureRoar";
                                    break;
                                }
                                case 6: {
                                    rowValues[2] = "creatureScream";
                                    break;
                                }
                                case 7: {
                                    rowValues[2] = "creatureLand";
                                }
                            }
                        }
                        if (rowValues[0] != null && rowValues[1] != null && rowValues[2] != null && whereComparison.testConditionOnRow(newRow = new Row(this.allColumns, rowValues))) {
                            if (updateValues != null && updateValues.containsKey("sound")) {
                                if (record.getName().equals("REGN")) {
                                    String newValue;
                                    HashMap<String, String> variables = new HashMap<String, String>();
                                    variables.put("sound", rowValues[1]);
                                    rowValues[1] = newValue = ModelFunctions.evaluateStringExpression(updateValues.get("sound"), variables);
                                    byte[] stringBytes = ModelFunctions.getBytesFromString(String.valueOf(newValue) + '\u0000');
                                    byte[] rawDataOld = soundSubRecord.getData().getRawData();
                                    byte[] rawDataNew = Arrays.copyOf(rawDataOld, rawDataOld.length);
                                    System.arraycopy(stringBytes, 0, rawDataNew, 0, stringBytes.length);
                                    try {
                                        SubRecord replaceSubrecod = new SubRecord("SNAM", rawDataNew, record);
                                        int soundSubRecordIndex = record.getSubRecords().indexOf(soundSubRecord);
                                        record.getSubRecords().remove(soundSubRecordIndex);
                                        record.getSubRecords().add(soundSubRecordIndex, replaceSubrecod);
                                    }
                                    catch (UnsupportedEncodingException e) {
                                        e.printStackTrace();
                                    }
                                } else {
                                    soundSubRecord.getData().setValueByString(updateValues.get("sound"));
                                    rowValues[1] = soundSubRecord.getData().getValueAsString();
                                }
                            }
                            if (selectedColumns != this.allColumns) {
                                newRow = newRow.createFractionRow(selectedColumns);
                            }
                            returnRows.add(newRow);
                        }
                    }
                    ++i2;
                }
            }
            ++i1;
        }
        return returnRows;
    }

    @Override
    public String getName() {
        return "soundReferences";
    }

    @Override
    public Columns getAllColumns() {
        return this.allColumns;
    }
}

