/*
 * Decompiled with CFR 0.152.
 */
package database.table;

import database.Columns;
import database.Row;
import database.table.Table;
import database.where.Comparison;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import model.ModelFunctions;
import model.Record;
import model.SubRecord;
import model.subrecorddata.SubRecordDataUnknown;

public class ScriptsTable
extends Table {
    protected Columns allColumns = new Columns(new String[]{"name", "byteCode", "text"}, new Columns.Type[]{Columns.Type.text, Columns.Type.text, Columns.Type.text}, new boolean[]{true, true, true});

    @Override
    public List<Row> insert(List<Record> records, List<Row> rows) {
        System.out.println("This table does not support insertion of rows yet.");
        return null;
    }

    @Override
    public List<Row> select(List<Record> records, Columns selectedColumns, Comparison whereComparison) {
        return this.executeRUD(records, selectedColumns, whereComparison, null, false);
    }

    @Override
    public List<Row> update(List<Record> records, Comparison whereComparison, Map<String, String> updateValues) {
        return this.executeRUD(records, this.allColumns, whereComparison, updateValues, false);
    }

    @Override
    public List<Row> delete(List<Record> records, Comparison whereComparison) {
        return this.executeRUD(records, this.allColumns, whereComparison, null, true);
    }

    private List<Row> executeRUD(List<Record> records, Columns selectedColumns, Comparison whereComparison, Map<String, String> updateValues, boolean delete) {
        ArrayList<Row> returnRows = new ArrayList<Row>();
        int i1 = 0;
        while (i1 < records.size()) {
            Record record = records.get(i1);
            if (record.getName().equals("SCPT")) {
                String[] rowValues = new String[this.allColumns.getLength()];
                int i2 = 0;
                while (i2 < record.getSubRecords().size()) {
                    SubRecord subRecord = record.getSubRecords().get(i2);
                    if (subRecord.getName().equals("SCHD")) {
                        String value = ModelFunctions.getStringFromBytes(Arrays.copyOfRange(subRecord.getData().getRawData(), 0, 32));
                        rowValues[this.allColumns.getPositionOf((String)"name")] = value.indexOf(0) != -1 ? value.substring(0, value.indexOf(0)) : value;
                    } else if (subRecord.getName().equals("SCDT")) {
                        rowValues[this.allColumns.getPositionOf((String)"byteCode")] = subRecord.getData().getValueAsString();
                    } else if (subRecord.getName().equals("SCTX")) {
                        rowValues[this.allColumns.getPositionOf((String)"text")] = subRecord.getData().getValueAsString();
                    }
                    ++i2;
                }
                Row newRow = new Row(this.allColumns, rowValues);
                if (whereComparison.testConditionOnRow(newRow)) {
                    if (updateValues != null) {
                        int i22 = 0;
                        while (i22 < record.getSubRecords().size()) {
                            String newValue;
                            HashMap<String, String> variables;
                            SubRecord subRecord = record.getSubRecords().get(i22);
                            if (subRecord.getName().equals("SCHD") && updateValues.containsKey("name")) {
                                variables = new HashMap<String, String>();
                                variables.put("name", rowValues[this.allColumns.getPositionOf("name")]);
                                newValue = ModelFunctions.evaluateStringExpression(updateValues.get("name"), variables);
                                byte[] nameBytes1 = ModelFunctions.getBytesFromString(newValue);
                                byte[] nameBytes2 = new byte[32];
                                System.arraycopy(nameBytes1, 0, nameBytes2, 0, nameBytes1.length);
                                byte[] rawData = subRecord.getData().getRawData();
                                System.arraycopy(nameBytes2, 0, rawData, 0, nameBytes2.length);
                                SubRecordDataUnknown subRecordData = new SubRecordDataUnknown(rawData);
                                record.getSubRecords().remove(i22);
                                record.getSubRecords().add(i22, new SubRecord("SCHD", subRecordData, record));
                                rowValues[this.allColumns.getPositionOf((String)"name")] = newValue;
                            } else if (subRecord.getName().equals("SCDT") && updateValues.containsKey("byteCode")) {
                                variables = new HashMap();
                                variables.put("byteCode", rowValues[this.allColumns.getPositionOf("byteCode")]);
                                newValue = ModelFunctions.evaluateStringExpression(updateValues.get("byteCode"), variables);
                                subRecord.getData().setValueByString(ModelFunctions.getEscapedString(newValue));
                                rowValues[this.allColumns.getPositionOf((String)"byteCode")] = newValue;
                            } else if (subRecord.getName().equals("SCTX") && updateValues.containsKey("text")) {
                                variables = new HashMap();
                                variables.put("text", rowValues[this.allColumns.getPositionOf("text")]);
                                newValue = ModelFunctions.evaluateStringExpression(updateValues.get("text"), variables);
                                subRecord.getData().setValueByString(ModelFunctions.getEscapedString(newValue));
                                rowValues[this.allColumns.getPositionOf((String)"text")] = newValue;
                            }
                            ++i22;
                        }
                    }
                    if (delete) {
                        records.remove(i1);
                        --i1;
                    }
                    if (selectedColumns != this.allColumns) {
                        newRow = newRow.createFractionRow(selectedColumns);
                    }
                    returnRows.add(newRow);
                }
            }
            ++i1;
        }
        return returnRows;
    }

    @Override
    public String getName() {
        return "scripts";
    }

    @Override
    public Columns getAllColumns() {
        return this.allColumns;
    }
}

