/*
 * Decompiled with CFR 0.152.
 */
package database.table;

import database.Columns;
import database.Row;
import database.table.Table;
import database.where.Comparison;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import model.Record;
import model.SubRecord;

public class ScriptReferencesTable
extends Table {
    protected Columns allColumns;

    public ScriptReferencesTable() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        this.allColumns = new Columns(new String[]{"owningObject", "script"}, new Columns.Type[]{Columns.Type.text, Columns.Type.text}, blArray);
    }

    @Override
    public List<Row> insert(List<Record> records, List<Row> rows) {
        System.out.println("This table does not support insertion.");
        return null;
    }

    @Override
    public List<Row> select(List<Record> records, Columns selectedColumns, Comparison whereComparison) {
        return this.executeRUD(records, selectedColumns, whereComparison, null, false);
    }

    @Override
    public List<Row> update(List<Record> records, Comparison whereComparison, Map<String, String> updateValues) {
        return this.executeRUD(records, this.allColumns, whereComparison, updateValues, false);
    }

    @Override
    public List<Row> delete(List<Record> records, Comparison whereComparison) {
        return this.executeRUD(records, this.allColumns, whereComparison, null, true);
    }

    private List<Row> executeRUD(List<Record> records, Columns selectedColumns, Comparison whereComparison, Map<String, String> updateValues, boolean delete) {
        ArrayList<Row> returnRows = new ArrayList<Row>();
        int i1 = 0;
        while (i1 < records.size()) {
            Record record = records.get(i1);
            String[] rowValues = new String[2];
            int i2 = 0;
            while (i2 < record.getSubRecords().size()) {
                SubRecord subRecord = record.getSubRecords().get(i2);
                if (subRecord.getName().equals("NAME")) {
                    rowValues[0] = subRecord.getData().getValueAsString();
                } else if (subRecord.getName().equals("SCRI")) {
                    Row newRow;
                    rowValues[1] = subRecord.getData().getValueAsString();
                    if (rowValues[0] != null && whereComparison.testConditionOnRow(newRow = new Row(this.allColumns, rowValues))) {
                        if (updateValues != null && updateValues.containsKey("script")) {
                            subRecord.getData().setValueByString(updateValues.get("script"));
                            rowValues[1] = subRecord.getData().getValueAsString();
                        }
                        if (delete) {
                            record.getSubRecords().remove(i2);
                            --i2;
                        }
                        if (selectedColumns != this.allColumns) {
                            newRow = newRow.createFractionRow(selectedColumns);
                        }
                        returnRows.add(newRow);
                    }
                    rowValues = Arrays.copyOf(rowValues, rowValues.length);
                }
                ++i2;
            }
            ++i1;
        }
        return returnRows;
    }

    @Override
    public String getName() {
        return "scriptReferences";
    }

    @Override
    public Columns getAllColumns() {
        return this.allColumns;
    }
}

