/*
 * Decompiled with CFR 0.152.
 */
package database.table;

import database.Columns;
import database.Row;
import database.table.Table;
import database.where.Comparison;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import model.ModelFunctions;
import model.Record;
import model.SubRecord;
import model.subrecorddata.SubRecordDataLong;
import model.subrecorddata.SubRecordDataString;

public class MasterFilesTable
extends Table {
    protected Columns allColumns = new Columns(new String[]{"name", "size"}, new Columns.Type[]{Columns.Type.text, Columns.Type.integer}, new boolean[]{true, true});

    @Override
    public List<Row> insert(List<Record> records, List<Row> rows) {
        ArrayList<Row> returnRows = new ArrayList<Row>();
        Record startRecord = records.get(0);
        if (!startRecord.getName().equals("TES3")) {
            throw new IllegalArgumentException("The first record in the passed record list must be a TES3 record.");
        }
        for (Row row : rows) {
            SubRecord subRecord1 = new SubRecord("MAST", new SubRecordDataString(ModelFunctions.getDeEscapedString(row.getValueOf("name")), "name", 0, 999), startRecord);
            SubRecord subRecord2 = new SubRecord("DATA", new SubRecordDataLong(Integer.parseInt(row.getValueOf("size")), "size"), startRecord);
            int insertionIndex = this.findInsertionIndex(startRecord.getSubRecords());
            startRecord.getSubRecords().add(insertionIndex, subRecord2);
            startRecord.getSubRecords().add(insertionIndex, subRecord1);
            returnRows.add(new Row(this.allColumns, new String[]{ModelFunctions.getDeEscapedString(row.getValueOf("name")), row.getValueOf("size")}));
        }
        return returnRows;
    }

    private int findInsertionIndex(List<SubRecord> subrecords) {
        int index = 0;
        while (index < subrecords.size()) {
            SubRecord subRecord = subrecords.get(index);
            if (subRecord.getName().equals("GMDT") || subRecord.getName().equals("SCRD") || subRecord.getName().equals("SCRS")) break;
            ++index;
        }
        return index;
    }

    @Override
    public List<Row> select(List<Record> records, Columns columns, Comparison whereComparison) {
        return this.executeRUD(records, columns, whereComparison, null, false);
    }

    @Override
    public List<Row> update(List<Record> records, Comparison whereComparison, Map<String, String> updateValues) {
        return this.executeRUD(records, this.getAllColumns(), whereComparison, updateValues, false);
    }

    @Override
    public List<Row> delete(List<Record> records, Comparison whereComparison) {
        return this.executeRUD(records, this.getAllColumns(), whereComparison, null, true);
    }

    @Override
    public String getName() {
        return "masterFiles";
    }

    @Override
    public Columns getAllColumns() {
        return this.allColumns;
    }

    private List<Row> executeRUD(List<Record> records, Columns selectedColumns, Comparison whereComparison, Map<String, String> updateValues, boolean delete) {
        ArrayList<Row> returnRows = new ArrayList<Row>();
        Record startRecord = records.get(0);
        if (!startRecord.getName().equals("TES3")) {
            throw new IllegalArgumentException("The first record in the passed record list must be a TES3 record.");
        }
        String currentMasterFile = null;
        int i = 0;
        while (i < startRecord.getSubRecords().size()) {
            SubRecord subRecord = startRecord.getSubRecords().get(i);
            if (subRecord.getName().equals("MAST")) {
                currentMasterFile = subRecord.getData().getValueAsString();
            } else if (subRecord.getName().equals("DATA")) {
                String fileSize = subRecord.getData().getValueAsString();
                String[] rowValues = new String[]{currentMasterFile, fileSize};
                Row newRow = new Row(this.allColumns, rowValues);
                if (whereComparison.testConditionOnRow(newRow)) {
                    if (updateValues != null) {
                        if (updateValues.containsKey("name")) {
                            startRecord.getSubRecords().get(i - 1).getData().setValueByString(updateValues.get("name"));
                            rowValues[0] = startRecord.getSubRecords().get(i - 1).getData().getValueAsString();
                        }
                        if (updateValues.containsKey("size")) {
                            subRecord.getData().setValueByString(updateValues.get("size"));
                            rowValues[1] = subRecord.getData().getValueAsString();
                        }
                    }
                    if (delete) {
                        startRecord.getSubRecords().remove(i);
                        startRecord.getSubRecords().remove(i - 1);
                        i -= 2;
                    }
                    if (selectedColumns != this.allColumns) {
                        newRow = newRow.createFractionRow(selectedColumns);
                    }
                    returnRows.add(newRow);
                }
            }
            ++i;
        }
        return returnRows;
    }
}

