/*
 * Decompiled with CFR 0.152.
 */
package database.table;

import database.Columns;
import database.Row;
import database.table.Table;
import database.where.Comparison;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import model.Record;
import model.SubRecord;

public class IDObjectsTable
extends Table {
    protected Columns allColumns;

    public IDObjectsTable() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        this.allColumns = new Columns(new String[]{"id", "type"}, new Columns.Type[]{Columns.Type.text, Columns.Type.text}, blArray);
    }

    @Override
    public List<Row> insert(List<Record> records, List<Row> rows) {
        System.out.println("This table does not support insertion of rows.");
        return null;
    }

    @Override
    public List<Row> select(List<Record> records, Columns selectedColumns, Comparison whereComparison) {
        return this.executeRUD(records, selectedColumns, whereComparison, null, false);
    }

    @Override
    public List<Row> update(List<Record> records, Comparison whereComparison, Map<String, String> updateValues) {
        return this.executeRUD(records, this.allColumns, whereComparison, updateValues, false);
    }

    @Override
    public List<Row> delete(List<Record> records, Comparison whereComparison) {
        return this.executeRUD(records, this.allColumns, whereComparison, null, true);
    }

    @Override
    public String getName() {
        return "idObjects";
    }

    @Override
    public Columns getAllColumns() {
        return this.allColumns;
    }

    private List<Row> executeRUD(List<Record> records, Columns selectedColumns, Comparison whereComparison, Map<String, String> updateValues, boolean delete) {
        ArrayList<Row> returnRows = new ArrayList<Row>(100);
        Iterator<Record> recordIterator = records.iterator();
        while (recordIterator.hasNext()) {
            Row newRow;
            Record record = recordIterator.next();
            if (!this.isIDObject(record.getName())) continue;
            SubRecord idSubRecord = null;
            String[] values = new String[2];
            values[1] = (String)recordNameToType.get(record.getName());
            if (values[1] == null) {
                values[1] = "unknown";
            }
            for (SubRecord subRecord : record.getSubRecords()) {
                if (!subRecord.getName().equals("NAME")) continue;
                idSubRecord = subRecord;
                values[0] = subRecord.getData().getValueAsString();
                break;
            }
            if (values[0] == null || !whereComparison.testConditionOnRow(newRow = new Row(this.allColumns, values))) continue;
            if (updateValues != null) {
                if (updateValues.containsKey("id")) {
                    idSubRecord.getData().setValueByString(updateValues.get("id"));
                    values[0] = idSubRecord.getData().getValueAsString();
                }
                if (updateValues.containsKey("type")) {
                    System.out.println("The type of an id object cannot be changed in this table.");
                }
            }
            if (delete) {
                recordIterator.remove();
            }
            if (selectedColumns != this.allColumns) {
                newRow = newRow.createFractionRow(selectedColumns);
            }
            returnRows.add(newRow);
        }
        return returnRows;
    }

    private boolean isIDObject(String name) {
        boolean noIDObject = name.equals("TES3") || name.equals("GMST") || name.equals("SKIL") || name.equals("MGEF") || name.equals("SCPT") || name.equals("LAND") || name.equals("PGRD") || name.equals("DIAL") || name.equals("INFO") || name.equals("CELL");
        return !noIDObject;
    }
}

