/*
 * Decompiled with CFR 0.152.
 */
package database.table;

import database.Columns;
import database.Row;
import database.table.Table;
import database.where.Comparison;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import model.Record;
import model.SubRecord;

public class FileReferencesTable
extends Table {
    protected Columns allColumns;

    public FileReferencesTable() {
        boolean[] blArray = new boolean[3];
        blArray[1] = true;
        this.allColumns = new Columns(new String[]{"owningObject", "file", "type"}, new Columns.Type[]{Columns.Type.text, Columns.Type.text, Columns.Type.text}, blArray);
    }

    @Override
    public List<Row> insert(List<Record> records, List<Row> rows) {
        System.out.println("This table does not support insertion.");
        return null;
    }

    @Override
    public List<Row> select(List<Record> records, Columns selectedColumns, Comparison whereComparison) {
        return this.executeRUD(records, selectedColumns, whereComparison, null, false);
    }

    @Override
    public List<Row> update(List<Record> records, Comparison whereComparison, Map<String, String> updateValues) {
        return this.executeRUD(records, this.allColumns, whereComparison, updateValues, false);
    }

    @Override
    public List<Row> delete(List<Record> records, Comparison whereComparison) {
        System.out.println("This table does not support deletion.");
        return null;
    }

    private List<Row> executeRUD(List<Record> records, Columns selectedColumns, Comparison whereComparison, Map<String, String> updateValues, boolean delete) {
        ArrayList<Row> returnRows = new ArrayList<Row>();
        int i1 = 0;
        while (i1 < records.size()) {
            Record record = records.get(i1);
            String[] rowValues = new String[3];
            SubRecord fileSubRecord = null;
            int i2 = 0;
            while (i2 < record.getSubRecords().size()) {
                SubRecord subRecord = record.getSubRecords().get(i2);
                if (subRecord.getName().equals("NAME")) {
                    rowValues[0] = subRecord.getData().getValueAsString();
                } else if (subRecord.getName().equals("MODL")) {
                    rowValues[1] = subRecord.getData().getValueAsString();
                    rowValues[2] = "model";
                    fileSubRecord = subRecord;
                } else if (subRecord.getName().equals("ITEX")) {
                    rowValues[1] = subRecord.getData().getValueAsString();
                    rowValues[2] = "icon";
                    fileSubRecord = subRecord;
                } else if (subRecord.getName().equals("DATA") && record.getName().equals("LTEX")) {
                    rowValues[1] = subRecord.getData().getValueAsString();
                    rowValues[2] = "texture";
                    fileSubRecord = subRecord;
                } else if (subRecord.getName().equals("FNAM") && record.getName().equals("SOUN")) {
                    rowValues[1] = subRecord.getData().getValueAsString();
                    rowValues[2] = "sound";
                    fileSubRecord = subRecord;
                }
                if (rowValues[0] != null && rowValues[1] != null && rowValues[2] != null) {
                    Row newRow = new Row(this.allColumns, rowValues);
                    if (whereComparison.testConditionOnRow(newRow)) {
                        if (updateValues != null && updateValues.containsKey("file")) {
                            fileSubRecord.getData().setValueByString(updateValues.get("file"));
                            rowValues[1] = fileSubRecord.getData().getValueAsString();
                        }
                        if (selectedColumns != this.allColumns) {
                            newRow = newRow.createFractionRow(selectedColumns);
                        }
                        returnRows.add(newRow);
                    }
                    String[] stringArray = new String[3];
                    stringArray[0] = rowValues[0];
                    rowValues = stringArray;
                }
                ++i2;
            }
            ++i1;
        }
        return returnRows;
    }

    @Override
    public String getName() {
        return "fileReferences";
    }

    @Override
    public Columns getAllColumns() {
        return this.allColumns;
    }
}

