/*
 * Decompiled with CFR 0.152.
 */
package database.table;

import database.Columns;
import database.Row;
import database.table.Table;
import database.where.Comparison;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import model.ModelFunctions;
import model.Record;
import model.SubRecord;
import model.subrecorddata.SubrecordDataFactionMembership;

public class FactionReferencesTable
extends Table {
    protected Columns allColumns;

    public FactionReferencesTable() {
        boolean[] blArray = new boolean[3];
        blArray[1] = true;
        this.allColumns = new Columns(new String[]{"owningObject", "faction", "type"}, new Columns.Type[]{Columns.Type.text, Columns.Type.text, Columns.Type.text}, blArray);
    }

    @Override
    public List<Row> insert(List<Record> records, List<Row> rows) {
        System.out.println("This table does not support insertion.");
        return null;
    }

    @Override
    public List<Row> select(List<Record> records, Columns selectedColumns, Comparison whereComparison) {
        return this.executeRUD(records, selectedColumns, whereComparison, null, false);
    }

    @Override
    public List<Row> update(List<Record> records, Comparison whereComparison, Map<String, String> updateValues) {
        return this.executeRUD(records, this.allColumns, whereComparison, updateValues, false);
    }

    @Override
    public List<Row> delete(List<Record> records, Comparison whereComparison) {
        System.out.println("This table does not support deletion.");
        return null;
    }

    private List<Row> executeRUD(List<Record> records, Columns selectedColumns, Comparison whereComparison, Map<String, String> updateValues, boolean delete) {
        ArrayList<Row> returnRows = new ArrayList<Row>();
        int i1 = 0;
        while (i1 < records.size()) {
            block20: {
                String owningObject;
                String type;
                Record record;
                block16: {
                    block19: {
                        block18: {
                            block17: {
                                block15: {
                                    record = records.get(i1);
                                    type = null;
                                    owningObject = null;
                                    if (!record.getName().equals("NPC_")) break block15;
                                    type = "membership";
                                    break block16;
                                }
                                if (!record.getName().equals("STLN")) break block17;
                                type = "originalOwner";
                                break block16;
                            }
                            if (!record.getName().equals("CELL")) break block18;
                            type = "owner";
                            break block16;
                        }
                        if (!record.getName().equals("FACT")) break block19;
                        type = "factionRelation";
                        break block16;
                    }
                    if (!record.getName().equals("PCDT")) break block20;
                    type = "playermembership";
                }
                int i2 = 0;
                while (i2 < record.getSubRecords().size()) {
                    SubrecordDataFactionMembership dataMembership;
                    String[] rowValues;
                    Row newRow;
                    SubRecord subRecord = record.getSubRecords().get(i2);
                    if (subRecord.getName().equals("NAME") && !record.getName().equals("PCDT")) {
                        owningObject = subRecord.getData().getValueAsString();
                    } else if (subRecord.getName().equals("ANAM") && record.getName().equals("NPC_") && !subRecord.getData().getValueAsString().equals("") || subRecord.getName().equals("CNAM") && record.getName().equals("CELL") || subRecord.getName().equals("FNAM") && record.getName().equals("STLN") || subRecord.getName().equals("ANAM") && record.getName().equals("FACT")) {
                        String[] rowValues2 = new String[]{owningObject, subRecord.getData().getValueAsString(), type};
                        Row newRow2 = new Row(this.allColumns, rowValues2);
                        if (whereComparison.testConditionOnRow(newRow2)) {
                            if (updateValues != null && updateValues.containsKey("faction")) {
                                subRecord.getData().setValueByString(updateValues.get("faction"));
                                rowValues2[1] = subRecord.getData().getValueAsString();
                            }
                            if (selectedColumns != this.allColumns) {
                                newRow2 = newRow2.createFractionRow(selectedColumns);
                            }
                            returnRows.add(newRow2);
                        }
                    } else if (subRecord.getName().equals("FNAM") && record.getName().equals("PCDT") && whereComparison.testConditionOnRow(newRow = new Row(this.allColumns, rowValues = new String[]{"player", (dataMembership = (SubrecordDataFactionMembership)subRecord.getData()).getFaction(), type}))) {
                        if (updateValues != null && updateValues.containsKey("faction")) {
                            HashMap<String, String> variables = new HashMap<String, String>();
                            variables.put("faction", dataMembership.getFaction());
                            String value = ModelFunctions.evaluateStringExpression(updateValues.get("faction"), variables);
                            dataMembership.setFaction(value);
                            rowValues[1] = dataMembership.getFaction();
                        }
                        if (selectedColumns != this.allColumns) {
                            newRow = newRow.createFractionRow(selectedColumns);
                        }
                        returnRows.add(newRow);
                    }
                    ++i2;
                }
            }
            ++i1;
        }
        return returnRows;
    }

    @Override
    public String getName() {
        return "factionReferences";
    }

    @Override
    public Columns getAllColumns() {
        return this.allColumns;
    }
}

