/*
 * Decompiled with CFR 0.152.
 */
package database.table;

import database.Columns;
import database.Row;
import database.table.Table;
import database.where.Comparison;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import model.ModelFunctions;
import model.Record;
import model.SubRecord;
import model.subrecorddata.SubRecordDataComposed;
import model.subrecorddata.SubRecordDataString;

public class ExteriorCellsTable
extends Table {
    protected Columns allColumns;

    public ExteriorCellsTable() {
        boolean[] blArray = new boolean[5];
        blArray[0] = true;
        blArray[3] = true;
        blArray[4] = true;
        this.allColumns = new Columns(new String[]{"name", "gridX", "gridY", "region", "illegalToSleepHere"}, new Columns.Type[]{Columns.Type.text, Columns.Type.integer, Columns.Type.integer, Columns.Type.text, Columns.Type.integer}, blArray);
    }

    @Override
    public List<Row> insert(List<Record> records, List<Row> rows) {
        System.out.println("This table does not support insertion of rows.");
        return null;
    }

    @Override
    public List<Row> select(List<Record> records, Columns selectedColumns, Comparison whereComparison) {
        return this.executeRUD(records, selectedColumns, whereComparison, null, false);
    }

    @Override
    public List<Row> update(List<Record> records, Comparison whereComparison, Map<String, String> updateValues) {
        if (this.allColumns.containsNonUpdatableFields(updateValues)) {
            System.out.println("gridX and gridY may not be updated.");
        }
        return this.executeRUD(records, this.allColumns, whereComparison, updateValues, false);
    }

    @Override
    public List<Row> delete(List<Record> records, Comparison whereComparison) {
        return this.executeRUD(records, this.allColumns, whereComparison, null, true);
    }

    private List<Row> executeRUD(List<Record> records, Columns selectedColumns, Comparison whereComparison, Map<String, String> updateValues, boolean delete) {
        ArrayList<Row> returnRows = new ArrayList<Row>(100);
        int i1 = 0;
        while (i1 < records.size()) {
            Record record = records.get(i1);
            if (record.getName().equals("CELL")) {
                Row newRow;
                String[] rowValues = this.allColumns.createEmptyRowValues();
                boolean noExteriorCell = false;
                int i2 = 0;
                while (i2 < record.getSubRecords().size()) {
                    SubRecord subRecord = record.getSubRecords().get(i2);
                    if (subRecord.getName().equals("FRMR")) break;
                    if (subRecord.getName().equals("NAME")) {
                        rowValues[this.allColumns.getPositionOf((String)"name")] = subRecord.getData().getValueAsString();
                    } else if (subRecord.getName().equals("RGNN")) {
                        rowValues[this.allColumns.getPositionOf((String)"region")] = subRecord.getData().getValueAsString();
                    } else if (subRecord.getName().equals("DATA")) {
                        SubRecordDataComposed composedSubRecordData = (SubRecordDataComposed)subRecord.getData();
                        String flags = composedSubRecordData.getValueAsStringOf("flags");
                        if (flags.equals("6")) {
                            rowValues[this.allColumns.getPositionOf((String)"illegalToSleepHere")] = "1";
                        } else if (flags.equals("2") || flags.equals("0")) {
                            rowValues[this.allColumns.getPositionOf((String)"illegalToSleepHere")] = "0";
                        } else {
                            noExteriorCell = true;
                            break;
                        }
                        rowValues[this.allColumns.getPositionOf((String)"gridX")] = composedSubRecordData.getValueAsStringOf("gridX");
                        rowValues[this.allColumns.getPositionOf((String)"gridY")] = composedSubRecordData.getValueAsStringOf("gridY");
                    }
                    ++i2;
                }
                if (!noExteriorCell && whereComparison.testConditionOnRow(newRow = new Row(this.allColumns, rowValues))) {
                    SubRecordDataComposed composedSubRecordData;
                    if (updateValues != null) {
                        boolean regionUpdated = false;
                        int i22 = 0;
                        while (i22 < record.getSubRecords().size()) {
                            SubRecord subRecord = record.getSubRecords().get(i22);
                            if (subRecord.getName().equals("FRMR")) break;
                            if (subRecord.getName().equals("NAME") && updateValues.containsKey("name")) {
                                subRecord.getData().setValueByString(updateValues.get("name"));
                                rowValues[this.allColumns.getPositionOf((String)"name")] = subRecord.getData().getValueAsString();
                            } else if (subRecord.getName().equals("RGNN") && updateValues.containsKey("region")) {
                                subRecord.getData().setValueByString(updateValues.get("region"));
                                rowValues[this.allColumns.getPositionOf((String)"region")] = subRecord.getData().getValueAsString();
                                if (subRecord.getData().getValueAsString().equals("")) {
                                    record.getSubRecords().remove(i22);
                                    --i22;
                                }
                                regionUpdated = true;
                            } else if (subRecord.getName().equals("DATA")) {
                                composedSubRecordData = (SubRecordDataComposed)subRecord.getData();
                                if (updateValues.containsKey("illegalToSleepHere")) {
                                    HashMap<String, Float> variables = new HashMap<String, Float>();
                                    variables.put("illegalToSleepHere", Float.valueOf(Float.parseFloat(rowValues[this.allColumns.getPositionOf("illegalToSleepHere")])));
                                    int newValue = Math.round(ModelFunctions.evaluateMathematicalExpression(updateValues.get("illegalToSleepHere"), variables));
                                    if (newValue < 1) {
                                        composedSubRecordData.setValueByStringFor("2", "flags");
                                        rowValues[this.allColumns.getPositionOf((String)"illegalToSleepHere")] = "0";
                                    } else {
                                        composedSubRecordData.setValueByStringFor("6", "flags");
                                        rowValues[this.allColumns.getPositionOf((String)"illegalToSleepHere")] = "1";
                                    }
                                }
                            }
                            ++i22;
                        }
                        if (!regionUpdated && updateValues.containsKey("region")) {
                            HashMap<String, String> variables = new HashMap<String, String>();
                            variables.put("region", "");
                            String newValue = ModelFunctions.evaluateStringExpression(updateValues.get("region"), variables);
                            SubRecordDataString subRecordData = new SubRecordDataString(newValue, "region", 0, 999);
                            SubRecord newSubRecord = new SubRecord("RGNN", subRecordData, record);
                            record.getSubRecords().add(2, newSubRecord);
                            rowValues[this.allColumns.getPositionOf((String)"region")] = newValue;
                        }
                    }
                    if (delete) {
                        int i23 = 0;
                        while (i23 < records.size()) {
                            SubRecord coordinateSubrecord;
                            Record searchRecord = records.get(i23);
                            if (searchRecord.getName().equals("LAND") && (composedSubRecordData = (SubRecordDataComposed)(coordinateSubrecord = searchRecord.getSubRecords().get(0)).getData()).getValueAsStringOf("gridX").equals(rowValues[this.allColumns.getPositionOf("gridX")]) && composedSubRecordData.getValueAsStringOf("gridY").equals(rowValues[this.allColumns.getPositionOf("gridY")])) {
                                records.remove(i23);
                                if (i23 >= i1) break;
                                --i1;
                                break;
                            }
                            ++i23;
                        }
                        records.remove(i1);
                        --i1;
                    }
                    if (selectedColumns != this.allColumns) {
                        newRow = newRow.createFractionRow(selectedColumns);
                    }
                    returnRows.add(newRow);
                }
            }
            ++i1;
        }
        return returnRows;
    }

    @Override
    public String getName() {
        return "exteriorCells";
    }

    @Override
    public Columns getAllColumns() {
        return this.allColumns;
    }
}

