/*
 * Decompiled with CFR 0.152.
 */
package database.table;

import database.Columns;
import database.Row;
import database.table.Table;
import database.where.Comparison;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import model.ModelFunctions;
import model.Record;
import model.SubRecord;
import model.subrecorddata.SubRecordData;
import model.subrecorddata.SubRecordDataByte;
import model.subrecorddata.SubRecordDataComposed;
import model.subrecorddata.SubRecordDataFloat;
import model.subrecorddata.SubRecordDataInt;
import model.subrecorddata.SubRecordDataSCVR;
import model.subrecorddata.SubRecordDataString;

public class DialogueResponsesTable
extends Table {
    protected Columns allColumns;
    private final List<String> infoSubRecordsInOrder;

    public DialogueResponsesTable() {
        boolean[] blArray = new boolean[50];
        blArray[1] = true;
        blArray[2] = true;
        blArray[3] = true;
        blArray[4] = true;
        blArray[5] = true;
        blArray[6] = true;
        blArray[7] = true;
        blArray[8] = true;
        blArray[9] = true;
        blArray[10] = true;
        blArray[11] = true;
        blArray[12] = true;
        blArray[13] = true;
        blArray[14] = true;
        blArray[15] = true;
        blArray[16] = true;
        blArray[17] = true;
        blArray[18] = true;
        blArray[19] = true;
        blArray[20] = true;
        blArray[21] = true;
        blArray[22] = true;
        blArray[23] = true;
        blArray[24] = true;
        blArray[25] = true;
        blArray[26] = true;
        blArray[27] = true;
        blArray[28] = true;
        blArray[29] = true;
        blArray[30] = true;
        blArray[31] = true;
        blArray[32] = true;
        blArray[33] = true;
        blArray[34] = true;
        blArray[35] = true;
        blArray[36] = true;
        blArray[37] = true;
        blArray[38] = true;
        blArray[39] = true;
        blArray[40] = true;
        blArray[41] = true;
        blArray[42] = true;
        blArray[43] = true;
        blArray[44] = true;
        blArray[45] = true;
        blArray[46] = true;
        blArray[47] = true;
        blArray[48] = true;
        blArray[49] = true;
        this.allColumns = new Columns(new String[]{"topic", "id", "previousResponseId", "followingResponseId", "disposition", "gender", "npc", "race", "class", "faction", "rank", "cell", "playersFaction", "playersRank", "text", "resultText", "sound", "journalName", "journalFinish", "journalRestart", "func1Type", "func1Func", "func1Value", "func1CompareOp", "func1TargetValue", "func2Type", "func2Func", "func2Value", "func2CompareOp", "func2TargetValue", "func3Type", "func3Func", "func3Value", "func3CompareOp", "func3TargetValue", "func4Type", "func4Func", "func4Value", "func4CompareOp", "func4TargetValue", "func5Type", "func5Func", "func5Value", "func5CompareOp", "func5TargetValue", "func6Type", "func6Func", "func6Value", "func6CompareOp", "func6TargetValue"}, new Columns.Type[]{Columns.Type.text, Columns.Type.text, Columns.Type.text, Columns.Type.text, Columns.Type.integer, Columns.Type.integer, Columns.Type.text, Columns.Type.text, Columns.Type.text, Columns.Type.text, Columns.Type.integer, Columns.Type.text, Columns.Type.text, Columns.Type.integer, Columns.Type.text, Columns.Type.text, Columns.Type.text, Columns.Type.integer, Columns.Type.integer, Columns.Type.integer, Columns.Type.text, Columns.Type.text, Columns.Type.text, Columns.Type.text, Columns.Type.number, Columns.Type.text, Columns.Type.text, Columns.Type.text, Columns.Type.text, Columns.Type.number, Columns.Type.text, Columns.Type.text, Columns.Type.text, Columns.Type.text, Columns.Type.number, Columns.Type.text, Columns.Type.text, Columns.Type.text, Columns.Type.text, Columns.Type.number, Columns.Type.text, Columns.Type.text, Columns.Type.text, Columns.Type.text, Columns.Type.number, Columns.Type.text, Columns.Type.text, Columns.Type.text, Columns.Type.text, Columns.Type.number}, blArray);
        this.infoSubRecordsInOrder = Arrays.asList("INAM", "PNAM", "NNAM", "DATA", "ONAM", "RNAM", "CNAM", "FNAM", "ANAM", "DNAM", "NAME", "SNAM", "QSTN", "QSTF", "QSTR", "SCVR", "INTV", "FLTV", "BNAM");
    }

    @Override
    public List<Row> insert(List<Record> records, List<Row> rows) {
        System.out.println("This table does not support insertion of rows yet.");
        return null;
    }

    @Override
    public List<Row> select(List<Record> records, Columns columns, Comparison whereComparison) {
        return this.executeRUD(records, columns, whereComparison, null, false);
    }

    @Override
    public List<Row> update(List<Record> records, Comparison whereComparison, Map<String, String> updateValues) {
        if (this.allColumns.containsNonUpdatableFields(updateValues)) {
            System.out.println("One or more of the specified columns cannot be updated.");
        }
        return this.executeRUD(records, this.getAllColumns(), whereComparison, updateValues, false);
    }

    @Override
    public List<Row> delete(List<Record> records, Comparison whereComparison) {
        return this.executeRUD(records, this.getAllColumns(), whereComparison, null, true);
    }

    private List<Row> executeRUD(List<Record> records, Columns selectedColumns, Comparison whereComparison, Map<String, String> updateValues, boolean delete) {
        ArrayList<Row> returnRows = new ArrayList<Row>();
        String currentTopic = null;
        int i1 = 0;
        while (i1 < records.size()) {
            Record record = records.get(i1);
            if (record.getName().equals("DIAL")) {
                for (SubRecord subRecord : record.getSubRecords()) {
                    if (!subRecord.getName().equals("NAME")) continue;
                    currentTopic = subRecord.getData().getValueAsString();
                    break;
                }
            }
            if (record.getName().equals("INFO")) {
                String[] currentDialogueResponseRowValues = this.allColumns.createEmptyRowValues();
                currentDialogueResponseRowValues[this.allColumns.getPositionOf((String)"topic")] = currentTopic;
                String currentResponseId = null;
                String previousResponseId = null;
                String nextResponseId = null;
                int currentSCVR = 0;
                List<SubRecord> allSubRecords = record.getSubRecords();
                int i = 0;
                while (i < allSubRecords.size()) {
                    SubRecord subRecord = allSubRecords.get(i);
                    if (subRecord.getName().equals("INAM")) {
                        currentDialogueResponseRowValues[this.allColumns.getPositionOf((String)"id")] = currentResponseId = subRecord.getData().getValueAsString();
                    } else if (subRecord.getName().equals("PNAM")) {
                        currentDialogueResponseRowValues[this.allColumns.getPositionOf((String)"previousResponseId")] = previousResponseId = subRecord.getData().getValueAsString();
                    } else if (subRecord.getName().equals("NNAM")) {
                        currentDialogueResponseRowValues[this.allColumns.getPositionOf((String)"followingResponseId")] = nextResponseId = subRecord.getData().getValueAsString();
                    } else if (subRecord.getName().equals("DATA")) {
                        SubRecordDataComposed composedData = (SubRecordDataComposed)subRecord.getData();
                        currentDialogueResponseRowValues[this.allColumns.getPositionOf((String)"disposition")] = composedData.getValueAsStringOf("disposition");
                        currentDialogueResponseRowValues[this.allColumns.getPositionOf((String)"rank")] = composedData.getValueAsStringOf("rank");
                        currentDialogueResponseRowValues[this.allColumns.getPositionOf((String)"gender")] = composedData.getValueAsStringOf("gender");
                        currentDialogueResponseRowValues[this.allColumns.getPositionOf((String)"playersRank")] = composedData.getValueAsStringOf("playersRank");
                    } else if (subRecord.getName().equals("ONAM")) {
                        currentDialogueResponseRowValues[this.allColumns.getPositionOf((String)"npc")] = subRecord.getData().getValueAsString();
                    } else if (subRecord.getName().equals("RNAM")) {
                        currentDialogueResponseRowValues[this.allColumns.getPositionOf((String)"race")] = subRecord.getData().getValueAsString();
                    } else if (subRecord.getName().equals("CNAM")) {
                        currentDialogueResponseRowValues[this.allColumns.getPositionOf((String)"class")] = subRecord.getData().getValueAsString();
                    } else if (subRecord.getName().equals("FNAM")) {
                        currentDialogueResponseRowValues[this.allColumns.getPositionOf((String)"faction")] = subRecord.getData().getValueAsString();
                    } else if (subRecord.getName().equals("ANAM")) {
                        currentDialogueResponseRowValues[this.allColumns.getPositionOf((String)"cell")] = subRecord.getData().getValueAsString();
                    } else if (subRecord.getName().equals("DNAM")) {
                        currentDialogueResponseRowValues[this.allColumns.getPositionOf((String)"playersFaction")] = subRecord.getData().getValueAsString();
                    } else if (subRecord.getName().equals("NAME")) {
                        currentDialogueResponseRowValues[this.allColumns.getPositionOf((String)"text")] = subRecord.getData().getValueAsString();
                    } else if (subRecord.getName().equals("SNAM")) {
                        currentDialogueResponseRowValues[this.allColumns.getPositionOf((String)"sound")] = subRecord.getData().getValueAsString();
                    } else if (subRecord.getName().equals("QSTN")) {
                        currentDialogueResponseRowValues[this.allColumns.getPositionOf((String)"journalName")] = subRecord.getData().getValueAsString();
                    } else if (subRecord.getName().equals("QSTF")) {
                        currentDialogueResponseRowValues[this.allColumns.getPositionOf((String)"journalFinish")] = subRecord.getData().getValueAsString();
                    } else if (subRecord.getName().equals("QSTR")) {
                        currentDialogueResponseRowValues[this.allColumns.getPositionOf((String)"journalRestart")] = subRecord.getData().getValueAsString();
                    } else if (subRecord.getName().equals("SCVR")) {
                        SubRecordDataSCVR scvrData = (SubRecordDataSCVR)subRecord.getData();
                        currentSCVR = scvrData.getNumberIndex() + 1;
                        currentDialogueResponseRowValues[this.allColumns.getPositionOf((String)new StringBuilder((String)"func").append((int)currentSCVR).append((String)"Type").toString())] = scvrData.getValueAsStringOf("type");
                        currentDialogueResponseRowValues[this.allColumns.getPositionOf((String)new StringBuilder((String)"func").append((int)currentSCVR).append((String)"Func").toString())] = scvrData.getValueAsStringOf("function");
                        currentDialogueResponseRowValues[this.allColumns.getPositionOf((String)new StringBuilder((String)"func").append((int)currentSCVR).append((String)"Value").toString())] = scvrData.getValueAsStringOf("value");
                        currentDialogueResponseRowValues[this.allColumns.getPositionOf((String)new StringBuilder((String)"func").append((int)currentSCVR).append((String)"CompareOp").toString())] = scvrData.getValueAsStringOf("compareOp");
                    } else if (subRecord.getName().equals("INTV") || subRecord.getName().equals("FLTV")) {
                        currentDialogueResponseRowValues[this.allColumns.getPositionOf((String)new StringBuilder((String)"func").append((int)currentSCVR).append((String)"TargetValue").toString())] = subRecord.getData().getValueAsString();
                    } else if (subRecord.getName().equals("BNAM")) {
                        currentDialogueResponseRowValues[this.allColumns.getPositionOf((String)"resultText")] = subRecord.getData().getValueAsString();
                    }
                    ++i;
                }
                Row newRow = new Row(this.allColumns, currentDialogueResponseRowValues);
                if (whereComparison.testConditionOnRow(newRow)) {
                    if (updateValues != null) {
                        int currentSCVRUpdate = 0;
                        LinkedList<String> updatedFields = new LinkedList<String>();
                        int i2 = 0;
                        while (i2 < allSubRecords.size()) {
                            SubRecord subRecord = allSubRecords.get(i2);
                            if (subRecord.getName().equals("INAM") && updateValues.containsKey("id")) {
                                subRecord.getData().setValueByString(updateValues.get("id"));
                                currentDialogueResponseRowValues[this.allColumns.getPositionOf((String)"id")] = subRecord.getData().getValueAsString();
                                updatedFields.add("id");
                            } else if (subRecord.getName().equals("PNAM") && updateValues.containsKey("previousResponseId")) {
                                subRecord.getData().setValueByString(updateValues.get("previousResponseId"));
                                currentDialogueResponseRowValues[this.allColumns.getPositionOf((String)"previousResponseId")] = subRecord.getData().getValueAsString();
                                updatedFields.add("previousResponseId");
                            } else if (subRecord.getName().equals("NNAM") && updateValues.containsKey("followingResponseId")) {
                                subRecord.getData().setValueByString(updateValues.get("followingResponseId"));
                                currentDialogueResponseRowValues[this.allColumns.getPositionOf((String)"followingResponseId")] = subRecord.getData().getValueAsString();
                                updatedFields.add("followingResponseId");
                            } else if (subRecord.getName().equals("DATA")) {
                                SubRecordDataComposed composedData = (SubRecordDataComposed)subRecord.getData();
                                if (updateValues.containsKey("disposition")) {
                                    composedData.setValueByStringFor(updateValues.get("disposition"), "disposition");
                                    currentDialogueResponseRowValues[this.allColumns.getPositionOf((String)"disposition")] = composedData.getValueAsStringOf("disposition");
                                    updatedFields.add("disposition");
                                }
                                if (updateValues.containsKey("rank")) {
                                    composedData.setValueByStringFor(updateValues.get("rank"), "rank");
                                    currentDialogueResponseRowValues[this.allColumns.getPositionOf((String)"rank")] = composedData.getValueAsStringOf("rank");
                                    updatedFields.add("rank");
                                }
                                if (updateValues.containsKey("gender")) {
                                    composedData.setValueByStringFor(updateValues.get("gender"), "gender");
                                    currentDialogueResponseRowValues[this.allColumns.getPositionOf((String)"gender")] = composedData.getValueAsStringOf("gender");
                                    updatedFields.add("gender");
                                }
                                if (updateValues.containsKey("playersRank")) {
                                    composedData.setValueByStringFor(updateValues.get("playersRank"), "playersRank");
                                    currentDialogueResponseRowValues[this.allColumns.getPositionOf((String)"playersRank")] = composedData.getValueAsStringOf("playersRank");
                                    updatedFields.add("playersRank");
                                }
                            } else if (subRecord.getName().equals("ONAM") && updateValues.containsKey("npc")) {
                                subRecord.getData().setValueByString(updateValues.get("npc"));
                                currentDialogueResponseRowValues[this.allColumns.getPositionOf((String)"npc")] = subRecord.getData().getValueAsString();
                                updatedFields.add("npc");
                                if (subRecord.getData().getValueAsString().equals("")) {
                                    allSubRecords.remove(i2);
                                    --i2;
                                }
                            } else if (subRecord.getName().equals("RNAM") && updateValues.containsKey("race")) {
                                subRecord.getData().setValueByString(updateValues.get("race"));
                                currentDialogueResponseRowValues[this.allColumns.getPositionOf((String)"race")] = subRecord.getData().getValueAsString();
                                updatedFields.add("race");
                                if (subRecord.getData().getValueAsString().equals("")) {
                                    allSubRecords.remove(i2);
                                    --i2;
                                }
                            } else if (subRecord.getName().equals("CNAM") && updateValues.containsKey("class")) {
                                subRecord.getData().setValueByString(updateValues.get("class"));
                                currentDialogueResponseRowValues[this.allColumns.getPositionOf((String)"class")] = subRecord.getData().getValueAsString();
                                updatedFields.add("class");
                                if (subRecord.getData().getValueAsString().equals("")) {
                                    allSubRecords.remove(i2);
                                    --i2;
                                }
                            } else if (subRecord.getName().equals("FNAM") && updateValues.containsKey("faction")) {
                                subRecord.getData().setValueByString(updateValues.get("faction"));
                                currentDialogueResponseRowValues[this.allColumns.getPositionOf((String)"faction")] = subRecord.getData().getValueAsString();
                                updatedFields.add("faction");
                                if (subRecord.getData().getValueAsString().equals("")) {
                                    allSubRecords.remove(i2);
                                    --i2;
                                }
                            } else if (subRecord.getName().equals("ANAM") && updateValues.containsKey("cell")) {
                                subRecord.getData().setValueByString(updateValues.get("cell"));
                                currentDialogueResponseRowValues[this.allColumns.getPositionOf((String)"cell")] = subRecord.getData().getValueAsString();
                                updatedFields.add("cell");
                                if (subRecord.getData().getValueAsString().equals("")) {
                                    allSubRecords.remove(i2);
                                    --i2;
                                }
                            } else if (subRecord.getName().equals("DNAM") && updateValues.containsKey("playersFaction")) {
                                subRecord.getData().setValueByString(updateValues.get("playersFaction"));
                                currentDialogueResponseRowValues[this.allColumns.getPositionOf((String)"playersFaction")] = subRecord.getData().getValueAsString();
                                updatedFields.add("playersFaction");
                                if (subRecord.getData().getValueAsString().equals("")) {
                                    allSubRecords.remove(i2);
                                    --i2;
                                }
                            } else if (subRecord.getName().equals("NAME") && updateValues.containsKey("text")) {
                                subRecord.getData().setValueByString(updateValues.get("text"));
                                currentDialogueResponseRowValues[this.allColumns.getPositionOf((String)"text")] = subRecord.getData().getValueAsString();
                                updatedFields.add("text");
                            } else if (subRecord.getName().equals("SNAM") && updateValues.containsKey("sound")) {
                                subRecord.getData().setValueByString(updateValues.get("sound"));
                                currentDialogueResponseRowValues[this.allColumns.getPositionOf((String)"sound")] = subRecord.getData().getValueAsString();
                                updatedFields.add("sound");
                                if (subRecord.getData().getValueAsString().equals("")) {
                                    allSubRecords.remove(i2);
                                    --i2;
                                }
                            } else if (subRecord.getName().equals("QSTN") && updateValues.containsKey("journalName")) {
                                subRecord.getData().setValueByString(updateValues.get("journalName"));
                                currentDialogueResponseRowValues[this.allColumns.getPositionOf((String)"journalName")] = subRecord.getData().getValueAsString();
                                updatedFields.add("journalName");
                                if (subRecord.getData().getValueAsString().equals("0")) {
                                    allSubRecords.remove(i2);
                                    --i2;
                                }
                            } else if (subRecord.getName().equals("QSTF") && updateValues.containsKey("journalFinish")) {
                                subRecord.getData().setValueByString(updateValues.get("journalFinish"));
                                currentDialogueResponseRowValues[this.allColumns.getPositionOf((String)"journalFinish")] = subRecord.getData().getValueAsString();
                                updatedFields.add("journalFinish");
                                if (subRecord.getData().getValueAsString().equals("0")) {
                                    allSubRecords.remove(i2);
                                    --i2;
                                }
                            } else if (subRecord.getName().equals("QSTR") && updateValues.containsKey("journalRestart")) {
                                subRecord.getData().setValueByString(updateValues.get("journalRestart"));
                                currentDialogueResponseRowValues[this.allColumns.getPositionOf((String)"journalRestart")] = subRecord.getData().getValueAsString();
                                updatedFields.add("journalRestart");
                                if (subRecord.getData().getValueAsString().equals("0")) {
                                    allSubRecords.remove(i2);
                                    --i2;
                                }
                            } else if (subRecord.getName().equals("SCVR")) {
                                SubRecordDataSCVR scvrData = (SubRecordDataSCVR)subRecord.getData();
                                currentSCVRUpdate = scvrData.getNumberIndex() + 1;
                                if (updateValues.containsKey("func" + currentSCVRUpdate + "Type")) {
                                    scvrData.setValueByStringFor(updateValues.get("func" + currentSCVRUpdate + "Type"), "type");
                                    currentDialogueResponseRowValues[this.allColumns.getPositionOf((String)new StringBuilder((String)"func").append((int)currentSCVRUpdate).append((String)"Type").toString())] = scvrData.getValueAsStringOf("type");
                                    updatedFields.add("func" + currentSCVRUpdate + "Type");
                                }
                                if (updateValues.containsKey("func" + currentSCVRUpdate + "Func")) {
                                    scvrData.setValueByStringFor(updateValues.get("func" + currentSCVRUpdate + "Func"), "function");
                                    currentDialogueResponseRowValues[this.allColumns.getPositionOf((String)new StringBuilder((String)"func").append((int)currentSCVRUpdate).append((String)"Func").toString())] = scvrData.getValueAsStringOf("function");
                                    updatedFields.add("func" + currentSCVRUpdate + "Func");
                                }
                                if (updateValues.containsKey("func" + currentSCVRUpdate + "Value")) {
                                    scvrData.setValueByStringFor(updateValues.get("func" + currentSCVRUpdate + "Value"), "value");
                                    currentDialogueResponseRowValues[this.allColumns.getPositionOf((String)new StringBuilder((String)"func").append((int)currentSCVRUpdate).append((String)"Value").toString())] = scvrData.getValueAsStringOf("value");
                                    updatedFields.add("func" + currentSCVRUpdate + "Value");
                                }
                                if (updateValues.containsKey("func" + currentSCVRUpdate + "CompareOp")) {
                                    scvrData.setValueByStringFor(updateValues.get("func" + currentSCVRUpdate + "CompareOp"), "compareOp");
                                    currentDialogueResponseRowValues[this.allColumns.getPositionOf((String)new StringBuilder((String)"func").append((int)currentSCVRUpdate).append((String)"CompareOp").toString())] = scvrData.getValueAsStringOf("compareOp");
                                    updatedFields.add("func" + currentSCVRUpdate + "CompareOp");
                                }
                                if (currentDialogueResponseRowValues[this.allColumns.getPositionOf("func" + currentSCVRUpdate + "Type")].equals("") && currentDialogueResponseRowValues[this.allColumns.getPositionOf("func" + currentSCVRUpdate + "Func")].equals("") && currentDialogueResponseRowValues[this.allColumns.getPositionOf("func" + currentSCVRUpdate + "Value")].equals("") && currentDialogueResponseRowValues[this.allColumns.getPositionOf("func" + currentSCVRUpdate + "CompareOp")].equals("")) {
                                    allSubRecords.remove(i2);
                                    if (allSubRecords.get(i2).getName().equals("INTV") || allSubRecords.get(i2).getName().equals("FLTV")) {
                                        currentDialogueResponseRowValues[this.allColumns.getPositionOf((String)new StringBuilder((String)"func").append((int)currentSCVR).append((String)"TargetValue").toString())] = "0";
                                        updatedFields.add("func" + currentSCVR + "TargetValue");
                                        allSubRecords.remove(i2);
                                    }
                                    --i2;
                                }
                            } else if ((subRecord.getName().equals("INTV") || subRecord.getName().equals("FLTV")) && updateValues.containsKey("func" + currentSCVR + "TargetValue")) {
                                subRecord.getData().setValueByString(updateValues.get("func" + currentSCVR + "TargetValue"));
                                currentDialogueResponseRowValues[this.allColumns.getPositionOf((String)new StringBuilder((String)"func").append((int)currentSCVR).append((String)"TargetValue").toString())] = subRecord.getData().getValueAsString();
                                updatedFields.add("func" + currentSCVR + "TargetValue");
                            } else if (subRecord.getName().equals("BNAM") && updateValues.containsKey("resultText")) {
                                subRecord.getData().setValueByString(updateValues.get("resultText"));
                                currentDialogueResponseRowValues[this.allColumns.getPositionOf((String)"resultText")] = subRecord.getData().getValueAsString();
                                updatedFields.add("resultText");
                                if (subRecord.getData().getValueAsString().equals("")) {
                                    allSubRecords.remove(i2);
                                    --i2;
                                }
                            }
                            ++i2;
                        }
                        HashMap<String, String> variablesString = new HashMap<String, String>();
                        HashMap<String, Float> variablesNumber = new HashMap<String, Float>();
                        String resultString = null;
                        float resultNumber = 0.0f;
                        SubRecordDataSCVR[] scvrs = new SubRecordDataSCVR[6];
                        float[] scvrTargetValues = new float[6];
                        for (String key : updateValues.keySet()) {
                            if (updatedFields.contains(key)) continue;
                            if (this.allColumns.isNumeric(key)) {
                                variablesNumber.put(key, new Float(0.0f));
                                resultNumber = ModelFunctions.evaluateMathematicalExpression(updateValues.get(key), variablesNumber);
                                currentDialogueResponseRowValues[this.allColumns.getPositionOf((String)key)] = resultNumber % 1.0f == 0.0f ? String.valueOf((int)resultNumber) : String.valueOf(resultNumber);
                            } else {
                                variablesString.put(key, "");
                                currentDialogueResponseRowValues[this.allColumns.getPositionOf((String)key)] = resultString = ModelFunctions.evaluateStringExpression(updateValues.get(key), variablesString);
                            }
                            SubRecord subRecord = null;
                            if (key.equals("npc")) {
                                if (resultString.equals("")) continue;
                                SubRecordDataString data = new SubRecordDataString(resultString, key, 1, 32);
                                subRecord = new SubRecord("ONAM", data, record);
                            } else if (key.equals("race")) {
                                if (resultString.equals("")) continue;
                                SubRecordDataString data = new SubRecordDataString(resultString, key, 0, 100);
                                subRecord = new SubRecord("RNAM", data, record);
                            } else if (key.equals("class")) {
                                if (resultString.equals("")) continue;
                                SubRecordDataString data = new SubRecordDataString(resultString, key, 0, 100);
                                subRecord = new SubRecord("CNAM", data, record);
                            } else if (key.equals("faction")) {
                                if (resultString.equals("")) continue;
                                SubRecordDataString data = new SubRecordDataString(resultString, key, 0, 100);
                                subRecord = new SubRecord("FNAM", data, record);
                            } else if (key.equals("cell")) {
                                if (resultString.equals("")) continue;
                                SubRecordDataString data = new SubRecordDataString(resultString, key, 0, 100);
                                subRecord = new SubRecord("ANAM", data, record);
                            } else if (key.equals("playersFaction")) {
                                if (resultString.equals("")) continue;
                                SubRecordDataString data = new SubRecordDataString(resultString, key, 0, 100);
                                subRecord = new SubRecord("DNAM", data, record);
                            } else if (key.equals("sound")) {
                                if (resultString.equals("")) continue;
                                SubRecordDataString data = new SubRecordDataString(resultString, key, 0, 100);
                                subRecord = new SubRecord("SNAM", data, record);
                            } else if (key.equals("journalName")) {
                                if (resultNumber == 0.0f) continue;
                                SubRecordDataByte data = new SubRecordDataByte((byte)resultNumber, key);
                                subRecord = new SubRecord("QSTN", data, record);
                            } else if (key.equals("journalFinish")) {
                                if (resultNumber == 0.0f) continue;
                                SubRecordDataByte data = new SubRecordDataByte((byte)resultNumber, key);
                                subRecord = new SubRecord("QSTF", data, record);
                            } else if (key.equals("journalRestart")) {
                                if (resultNumber == 0.0f) continue;
                                SubRecordDataByte data = new SubRecordDataByte((byte)resultNumber, key);
                                subRecord = new SubRecord("QSTR", data, record);
                            } else if (key.equals("resultText")) {
                                if (resultString.equals("")) continue;
                                SubRecordDataString data = new SubRecordDataString(resultString, key, 0, 9999);
                                subRecord = new SubRecord("BNAM", data, record);
                            } else if (key.startsWith("func")) {
                                int position = Integer.parseInt(key.substring(4, 5)) - 1;
                                if (key.endsWith("TargetValue")) {
                                    scvrTargetValues[position] = resultNumber;
                                    continue;
                                }
                                SubRecordDataSCVR scvr = scvrs[position];
                                if (scvr == null) {
                                    scvrs[position] = scvr = new SubRecordDataSCVR(position);
                                }
                                if (key.endsWith("Type")) {
                                    scvr.setValueByStringFor(updateValues.get(key), "type");
                                    continue;
                                }
                                if (key.endsWith("Func")) {
                                    scvr.setValueByStringFor(updateValues.get(key), "function");
                                    continue;
                                }
                                if (key.endsWith("Value")) {
                                    scvr.setValueByStringFor(updateValues.get(key), "value");
                                    continue;
                                }
                                if (key.endsWith("CompareOp")) {
                                    scvr.setValueByStringFor(updateValues.get(key), "compareOp");
                                    continue;
                                }
                                if (!key.endsWith("TargetValue")) continue;
                                scvr.setValueByStringFor(updateValues.get(key), "value");
                                continue;
                            }
                            this.insertSubRecordAtRightIndex(subRecord, record);
                        }
                        int i3 = 0;
                        while (i3 < scvrs.length) {
                            SubRecordDataSCVR scvr = scvrs[i3];
                            if (scvr != null) {
                                SubRecord targetValueSubRecord;
                                SubRecordData targetValueSubRecordData;
                                if (scvrTargetValues[i3] % 1.0f > 0.0f) {
                                    targetValueSubRecordData = new SubRecordDataFloat(scvrTargetValues[i3], "func" + (i3 + 1) + "TargetValue", 3);
                                    targetValueSubRecord = new SubRecord("FLTV", targetValueSubRecordData, record);
                                } else {
                                    targetValueSubRecordData = new SubRecordDataInt((int)scvrTargetValues[i3], "func" + (i3 + 1) + "TargetValue");
                                    targetValueSubRecord = new SubRecord("INTV", targetValueSubRecordData, record);
                                }
                                int insertionIndex = this.findInsertionIndexForSCRV(i3, record);
                                record.getSubRecords().add(insertionIndex, new SubRecord("SCVR", scvr, record));
                                record.getSubRecords().add(insertionIndex + 1, targetValueSubRecord);
                            }
                            ++i3;
                        }
                    }
                    if (delete) {
                        records.remove(i1);
                        --i1;
                        for (Record searchRecord : records) {
                            if (!record.getName().equals("INFO")) continue;
                            for (SubRecord searchSubRecord : searchRecord.getSubRecords()) {
                                if (searchSubRecord.getName().equals("NNAM") && searchSubRecord.getData().getValueAsString().equals(currentResponseId)) {
                                    if (nextResponseId == null) continue;
                                    searchSubRecord.getData().setValueByString(ModelFunctions.getEscapedString(nextResponseId));
                                    continue;
                                }
                                if (!searchSubRecord.getName().equals("PNAM") || !searchSubRecord.getData().getValueAsString().equals(currentResponseId) || previousResponseId == null) continue;
                                searchSubRecord.getData().setValueByString(ModelFunctions.getEscapedString(previousResponseId));
                            }
                        }
                    }
                    if (selectedColumns != this.allColumns) {
                        newRow = newRow.createFractionRow(selectedColumns);
                    }
                    returnRows.add(newRow);
                }
            }
            ++i1;
        }
        return returnRows;
    }

    @Override
    public String getName() {
        return "dialogueResponses";
    }

    @Override
    public Columns getAllColumns() {
        return this.allColumns;
    }

    private void insertSubRecordAtRightIndex(SubRecord subRecord, Record record) {
        int insertionIndex = this.findInsertionIndexFor(subRecord.getName(), record);
        record.getSubRecords().add(insertionIndex, subRecord);
    }

    private int findInsertionIndexFor(String subRecordName, Record record) {
        int index1 = this.infoSubRecordsInOrder.indexOf(subRecordName);
        int i = 0;
        while (i < record.getSubRecords().size()) {
            SubRecord subRecord = record.getSubRecords().get(i);
            int index2 = this.infoSubRecordsInOrder.indexOf(subRecord.getName());
            if (index2 > index1) break;
            ++i;
        }
        return i;
    }

    private int findInsertionIndexForSCRV(int index, Record record) {
        int i = 0;
        while (i < record.getSubRecords().size()) {
            SubRecordDataSCVR subRecordData;
            SubRecord subRecord = record.getSubRecords().get(i);
            if (subRecord.getName().equals("SCVR") && (subRecordData = (SubRecordDataSCVR)subRecord.getData()).getNumberIndex() > index || subRecord.getName().equals("BNAM")) break;
            ++i;
        }
        return i;
    }
}

