/*
 * Decompiled with CFR 0.152.
 */
package database.table;

import database.Columns;
import database.Row;
import database.table.Table;
import database.where.Comparison;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import model.Record;
import model.SubRecord;

public class ClassReferencesTable
extends Table {
    protected Columns allColumns;

    public ClassReferencesTable() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        this.allColumns = new Columns(new String[]{"owningObject", "class"}, new Columns.Type[]{Columns.Type.text, Columns.Type.text}, blArray);
    }

    @Override
    public List<Row> insert(List<Record> records, List<Row> rows) {
        System.out.println("This table does not support insertion.");
        return null;
    }

    @Override
    public List<Row> select(List<Record> records, Columns selectedColumns, Comparison whereComparison) {
        return this.executeRUD(records, selectedColumns, whereComparison, null, false);
    }

    @Override
    public List<Row> update(List<Record> records, Comparison whereComparison, Map<String, String> updateValues) {
        return this.executeRUD(records, this.allColumns, whereComparison, updateValues, false);
    }

    @Override
    public List<Row> delete(List<Record> records, Comparison whereComparison) {
        System.out.println("This table does not support deletion.");
        return null;
    }

    private List<Row> executeRUD(List<Record> records, Columns selectedColumns, Comparison whereComparison, Map<String, String> updateValues, boolean delete) {
        ArrayList<Row> returnRows = new ArrayList<Row>();
        int i1 = 0;
        while (i1 < records.size()) {
            Record record = records.get(i1);
            if (record.getName().equals("NPC_")) {
                String owningObject = null;
                int i2 = 0;
                while (i2 < record.getSubRecords().size()) {
                    String[] rowValues;
                    Row newRow;
                    SubRecord subRecord = record.getSubRecords().get(i2);
                    if (subRecord.getName().equals("NAME")) {
                        owningObject = subRecord.getData().getValueAsString();
                    } else if (subRecord.getName().equals("CNAM") && whereComparison.testConditionOnRow(newRow = new Row(this.allColumns, rowValues = new String[]{owningObject, subRecord.getData().getValueAsString()}))) {
                        if (updateValues != null && updateValues.containsKey("class")) {
                            subRecord.getData().setValueByString(updateValues.get("class"));
                            rowValues[1] = subRecord.getData().getValueAsString();
                        }
                        if (selectedColumns != this.allColumns) {
                            newRow = newRow.createFractionRow(selectedColumns);
                        }
                        returnRows.add(newRow);
                    }
                    ++i2;
                }
            }
            ++i1;
        }
        return returnRows;
    }

    @Override
    public String getName() {
        return "classReferences";
    }

    @Override
    public Columns getAllColumns() {
        return this.allColumns;
    }
}

