/*
 * Decompiled with CFR 0.152.
 */
package database.table;

import database.Columns;
import database.Row;
import database.table.Table;
import database.where.Comparison;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import model.ModelFunctions;
import model.Record;
import model.SubRecord;
import model.subrecorddata.SubRecordDataFloat;
import model.subrecorddata.SubRecordDataInt;
import model.subrecorddata.SubRecordDataObjectCoordinates;
import model.subrecorddata.SubRecordDataString;

public class CellObjectsTable
extends Table {
    protected Columns allColumns;

    public CellObjectsTable() {
        boolean[] blArray = new boolean[10];
        blArray[2] = true;
        blArray[3] = true;
        blArray[4] = true;
        blArray[5] = true;
        blArray[6] = true;
        blArray[7] = true;
        blArray[8] = true;
        blArray[9] = true;
        this.allColumns = new Columns(new String[]{"cell", "cellRegion", "id", "scale", "xPos", "yPos", "zPos", "xRotate", "yRotate", "zRotate"}, new Columns.Type[]{Columns.Type.text, Columns.Type.text, Columns.Type.text, Columns.Type.number, Columns.Type.number, Columns.Type.number, Columns.Type.number, Columns.Type.number, Columns.Type.number, Columns.Type.number}, blArray);
    }

    @Override
    public List<Row> insert(List<Record> records, List<Row> rows) {
        return this.executeCRUD(records, new Columns(new String[0], new Columns.Type[0]), null, null, rows, false);
    }

    @Override
    public List<Row> select(List<Record> records, Columns columns, Comparison whereComparison) {
        return this.executeCRUD(records, columns, whereComparison, null, null, false);
    }

    @Override
    public List<Row> update(List<Record> records, Comparison whereComparison, Map<String, String> updateValues) {
        if (this.allColumns.containsNonUpdatableFields(updateValues)) {
            System.out.println("One or more of the specified columns cannot be updated.");
        }
        return this.executeCRUD(records, this.getAllColumns(), whereComparison, updateValues, null, false);
    }

    @Override
    public List<Row> delete(List<Record> records, Comparison whereComparison) {
        return this.executeCRUD(records, this.getAllColumns(), whereComparison, null, null, true);
    }

    /*
     * Unable to fully structure code
     */
    private List<Row> executeCRUD(List<Record> records, Columns selectedColumns, Comparison whereComparison, Map<String, String> updateValues, List<Row> insertRows, boolean delete) {
        returnRows = new ArrayList<Row>();
        for (Record record : records) {
            if (!record.getName().equals("CELL")) continue;
            allSubRecords = record.getSubRecords();
            cellObjectsStarted = false;
            indexOffsetByDeletion = 0;
            insertRowIndex = 1;
            subRecordsOfCellObject = new LinkedList<SubRecord>();
            currentCellObjectRowValues = null;
            currentCellName = null;
            currentRegionName = "";
            i = 0;
            while (i < allSubRecords.size()) {
                subRecord = allSubRecords.get(i);
                if (cellObjectsStarted) ** GOTO lbl-1000
                if (subRecord.getName().equals("NAME")) {
                    currentCellName = subRecord.getData().getValueAsString();
                } else if (subRecord.getName().equals("RGNN")) {
                    currentRegionName = subRecord.getData().getValueAsString();
                } else if (subRecord.getName().equals("FRMR")) {
                    if (!cellObjectsStarted) {
                        cellObjectsStarted = true;
                    }
                    if (indexOffsetByDeletion != 0) {
                        subRecord.getData().setValueByString("index-" + indexOffsetByDeletion);
                    }
                    ++insertRowIndex;
                    subRecordsOfCellObject.clear();
                    subRecordsOfCellObject.add(subRecord);
                    currentCellObjectRowValues = new String[this.allColumns.getLength()];
                    currentCellObjectRowValues[this.allColumns.getPositionOf((String)"cell")] = currentCellName;
                    currentCellObjectRowValues[this.allColumns.getPositionOf((String)"cellRegion")] = currentRegionName;
                } else if (cellObjectsStarted) {
                    subRecordsOfCellObject.add(subRecord);
                    if (subRecord.getName().equals("NAME")) {
                        currentCellObjectRowValues[this.allColumns.getPositionOf((String)"id")] = subRecord.getData().getValueAsString();
                    } else if (subRecord.getName().equals("XSCL")) {
                        currentCellObjectRowValues[this.allColumns.getPositionOf((String)"scale")] = subRecord.getData().getValueAsString();
                    } else if (subRecord.getName().equals("DATA") || subRecord.getName().equals("DELE")) {
                        coordinateData = subRecord.getName().equals("DATA") != false ? (SubRecordDataObjectCoordinates)subRecord.getData() : new SubRecordDataObjectCoordinates(new byte[24]);
                        currentCellObjectRowValues[this.allColumns.getPositionOf((String)"xPos")] = ModelFunctions.formatFloatNumber(coordinateData.getxPos(), 3);
                        currentCellObjectRowValues[this.allColumns.getPositionOf((String)"yPos")] = ModelFunctions.formatFloatNumber(coordinateData.getyPos(), 3);
                        currentCellObjectRowValues[this.allColumns.getPositionOf((String)"zPos")] = ModelFunctions.formatFloatNumber(coordinateData.getzPos(), 3);
                        currentCellObjectRowValues[this.allColumns.getPositionOf((String)"xRotate")] = ModelFunctions.formatFloatNumber(coordinateData.getxRotate(), 3);
                        currentCellObjectRowValues[this.allColumns.getPositionOf((String)"yRotate")] = ModelFunctions.formatFloatNumber(coordinateData.getyRotate(), 3);
                        currentCellObjectRowValues[this.allColumns.getPositionOf((String)"zRotate")] = ModelFunctions.formatFloatNumber(coordinateData.getzRotate(), 3);
                        if (currentCellObjectRowValues[this.allColumns.getPositionOf("scale")] == null) {
                            currentCellObjectRowValues[this.allColumns.getPositionOf((String)"scale")] = "1.00";
                        }
                        newRow = new Row(this.allColumns, currentCellObjectRowValues);
                        if (whereComparison != null && whereComparison.testConditionOnRow(newRow)) {
                            if (selectedColumns != this.allColumns) {
                                newRow = newRow.createFractionRow(selectedColumns);
                                currentCellObjectRowValues = newRow.getValues();
                            }
                            returnRows.add(newRow);
                            if (delete) {
                                for (SubRecord deleteSubRecord : subRecordsOfCellObject) {
                                    allSubRecords.remove(deleteSubRecord);
                                    --i;
                                }
                                ++indexOffsetByDeletion;
                                --insertRowIndex;
                            } else if (updateValues != null && updateValues.size() > 0) {
                                hasXSCL = false;
                                for (SubRecord updateSubRecord : subRecordsOfCellObject) {
                                    if (updateSubRecord.getName().equals("NAME")) {
                                        if (!updateValues.containsKey("id")) continue;
                                        updateSubRecord.getData().setValueByString(updateValues.get("id"));
                                        currentCellObjectRowValues[selectedColumns.getPositionOf((String)"id")] = updateSubRecord.getData().getValueAsString();
                                        if (updateValues.size() != 1) continue;
                                        break;
                                    }
                                    if (updateSubRecord.getName().equals("XSCL")) {
                                        hasXSCL = true;
                                        if (!updateValues.containsKey("scale")) continue;
                                        updateSubRecord.getData().setValueByString(updateValues.get("scale"));
                                        currentCellObjectRowValues[selectedColumns.getPositionOf((String)"scale")] = updateSubRecord.getData().getValueAsString();
                                        continue;
                                    }
                                    if (!updateSubRecord.getName().equals("DATA")) continue;
                                    updateSubRecordCoordinateData = (SubRecordDataObjectCoordinates)updateSubRecord.getData();
                                    variables = new HashMap<String, Float>();
                                    variables.put("xPos", Float.valueOf(updateSubRecordCoordinateData.getxPos()));
                                    variables.put("yPos", Float.valueOf(updateSubRecordCoordinateData.getyPos()));
                                    variables.put("zPos", Float.valueOf(updateSubRecordCoordinateData.getzPos()));
                                    variables.put("xRotate", Float.valueOf(updateSubRecordCoordinateData.getxRotate()));
                                    variables.put("yRotate", Float.valueOf(updateSubRecordCoordinateData.getyRotate()));
                                    variables.put("zRotate", Float.valueOf(updateSubRecordCoordinateData.getzRotate()));
                                    if (updateValues.containsKey("xPos")) {
                                        updateSubRecordCoordinateData.setxPos(ModelFunctions.evaluateMathematicalExpression(updateValues.get("xPos"), variables));
                                        currentCellObjectRowValues[selectedColumns.getPositionOf((String)"xPos")] = ModelFunctions.formatFloatNumber(updateSubRecordCoordinateData.getxPos(), 3);
                                    }
                                    if (updateValues.containsKey("yPos")) {
                                        updateSubRecordCoordinateData.setyPos(ModelFunctions.evaluateMathematicalExpression(updateValues.get("yPos"), variables));
                                        currentCellObjectRowValues[selectedColumns.getPositionOf((String)"yPos")] = ModelFunctions.formatFloatNumber(updateSubRecordCoordinateData.getyPos(), 3);
                                    }
                                    if (updateValues.containsKey("zPos")) {
                                        updateSubRecordCoordinateData.setzPos(ModelFunctions.evaluateMathematicalExpression(updateValues.get("zPos"), variables));
                                        currentCellObjectRowValues[selectedColumns.getPositionOf((String)"zPos")] = ModelFunctions.formatFloatNumber(updateSubRecordCoordinateData.getzPos(), 3);
                                    }
                                    if (updateValues.containsKey("xRotate")) {
                                        updateSubRecordCoordinateData.setxRotate(ModelFunctions.evaluateMathematicalExpression(updateValues.get("xRotate"), variables));
                                        currentCellObjectRowValues[selectedColumns.getPositionOf((String)"xRotate")] = ModelFunctions.formatFloatNumber(updateSubRecordCoordinateData.getxRotate(), 3);
                                    }
                                    if (updateValues.containsKey("yRotate")) {
                                        updateSubRecordCoordinateData.setyRotate(ModelFunctions.evaluateMathematicalExpression(updateValues.get("yRotate"), variables));
                                        currentCellObjectRowValues[selectedColumns.getPositionOf((String)"yRotate")] = ModelFunctions.formatFloatNumber(updateSubRecordCoordinateData.getyRotate(), 3);
                                    }
                                    if (updateValues.containsKey("zRotate")) {
                                        updateSubRecordCoordinateData.setzRotate(ModelFunctions.evaluateMathematicalExpression(updateValues.get("zRotate"), variables));
                                        currentCellObjectRowValues[selectedColumns.getPositionOf((String)"zRotate")] = ModelFunctions.formatFloatNumber(updateSubRecordCoordinateData.getzRotate(), 3);
                                    }
                                    if (hasXSCL || !updateValues.containsKey("scale")) continue;
                                    scaleVariable = new HashMap<String, Float>();
                                    scaleVariable.put("scale", new Float(1.0f));
                                    scale = ModelFunctions.evaluateMathematicalExpression(updateValues.get("scale"), scaleVariable);
                                    currentCellObjectRowValues[this.allColumns.getPositionOf((String)"scale")] = ModelFunctions.formatFloatNumber(scale, 2);
                                    if (scale == 1.0f) continue;
                                    scaleSubRecord = new SubRecord("XSCL", new SubRecordDataFloat(scale, "scale", 2), record);
                                    allSubRecords.add(i, scaleSubRecord);
                                    ++i;
                                }
                            }
                        }
                    }
                }
                ++i;
            }
            if (insertRows == null) continue;
            i = 0;
            while (i < insertRows.size()) {
                block47: {
                    block48: {
                        block46: {
                            insertRow = insertRows.get(i);
                            newCellObjectRowValues = new String[this.allColumns.getLength()];
                            if (!insertRow.hasColumn("cell")) break block46;
                            cell = ModelFunctions.evaluateStringExpression(insertRow.getValueOf("cell"));
                            if (!cell.equalsIgnoreCase(currentCellName)) break block47;
                            newCellObjectRowValues[this.allColumns.getPositionOf((String)"cell")] = currentCellName;
                        }
                        if (!insertRow.hasColumn("cellRegion")) break block48;
                        region = ModelFunctions.evaluateStringExpression(insertRow.getValueOf("cellRegion"));
                        if (!region.equalsIgnoreCase(currentRegionName)) break block47;
                        newCellObjectRowValues[this.allColumns.getPositionOf((String)"cellRegion")] = currentRegionName;
                    }
                    indexSubRecord = new SubRecord("FRMR", new SubRecordDataInt(insertRowIndex, "index"), record);
                    allSubRecords.add(indexSubRecord);
                    ++insertRowIndex;
                    if (!insertRow.hasColumn("id")) {
                        System.out.println("an id needs to be specified to create a new cell object");
                        return null;
                    }
                    id = ModelFunctions.evaluateStringExpression(insertRow.getValueOf("id"));
                    idSubRecord = new SubRecord("NAME", new SubRecordDataString(id, "id", 1, 32), record);
                    allSubRecords.add(idSubRecord);
                    newCellObjectRowValues[this.allColumns.getPositionOf((String)"id")] = insertRow.getValueOf("id");
                    if (insertRow.hasColumn("scale")) {
                        scale = ModelFunctions.evaluateMathematicalExpression(insertRow.getValueOf("scale"));
                        if (scale != 1.0f) {
                            scaleSubRecord = new SubRecord("XSCL", new SubRecordDataFloat(scale, "scale", 2), record);
                            allSubRecords.add(scaleSubRecord);
                        }
                    } else {
                        scale = 1.0f;
                    }
                    newCellObjectRowValues[this.allColumns.getPositionOf((String)"scale")] = ModelFunctions.formatFloatNumber(scale, 2);
                    newSubRecordCoordinateData = new SubRecordDataObjectCoordinates(new byte[24]);
                    if (insertRow.hasColumn("xPos")) {
                        newSubRecordCoordinateData.setxPos(ModelFunctions.evaluateMathematicalExpression(insertRow.getValueOf("xPos")));
                    }
                    newCellObjectRowValues[this.allColumns.getPositionOf((String)"xPos")] = ModelFunctions.formatFloatNumber(newSubRecordCoordinateData.getxPos(), 3);
                    if (insertRow.hasColumn("yPos")) {
                        newSubRecordCoordinateData.setyPos(ModelFunctions.evaluateMathematicalExpression(insertRow.getValueOf("yPos")));
                    }
                    newCellObjectRowValues[this.allColumns.getPositionOf((String)"yPos")] = ModelFunctions.formatFloatNumber(newSubRecordCoordinateData.getyPos(), 3);
                    if (insertRow.hasColumn("zPos")) {
                        newSubRecordCoordinateData.setzPos(ModelFunctions.evaluateMathematicalExpression(insertRow.getValueOf("zPos")));
                    }
                    newCellObjectRowValues[this.allColumns.getPositionOf((String)"zPos")] = ModelFunctions.formatFloatNumber(newSubRecordCoordinateData.getzPos(), 3);
                    if (insertRow.hasColumn("xRotate")) {
                        newSubRecordCoordinateData.setxRotate(ModelFunctions.evaluateMathematicalExpression(insertRow.getValueOf("xRotate")));
                    }
                    newCellObjectRowValues[this.allColumns.getPositionOf((String)"xRotate")] = ModelFunctions.formatFloatNumber(newSubRecordCoordinateData.getxRotate(), 3);
                    if (insertRow.hasColumn("yRotate")) {
                        newSubRecordCoordinateData.setyRotate(ModelFunctions.evaluateMathematicalExpression(insertRow.getValueOf("yRotate")));
                    }
                    newCellObjectRowValues[this.allColumns.getPositionOf((String)"yRotate")] = ModelFunctions.formatFloatNumber(newSubRecordCoordinateData.getyRotate(), 3);
                    if (insertRow.hasColumn("zRotate")) {
                        newSubRecordCoordinateData.setzRotate(ModelFunctions.evaluateMathematicalExpression(insertRow.getValueOf("zRotate")));
                    }
                    newCellObjectRowValues[this.allColumns.getPositionOf((String)"zRotate")] = ModelFunctions.formatFloatNumber(newSubRecordCoordinateData.getzRotate(), 3);
                    coordinatesSubRecord = new SubRecord("DATA", newSubRecordCoordinateData, record);
                    allSubRecords.add(coordinatesSubRecord);
                    returnRows.add(new Row(this.allColumns, newCellObjectRowValues));
                }
                ++i;
            }
        }
        return returnRows;
    }

    @Override
    public String getName() {
        return "cellObjects";
    }

    @Override
    public Columns getAllColumns() {
        return this.allColumns;
    }
}

