/*
 * Decompiled with CFR 0.152.
 */
package database;

import database.Statement;
import database.Tables;
import database.table.Table;
import database.where.AlwaysTrueComparison;
import database.where.Comparison;
import database.where.WhereEvaluator;
import java.util.HashMap;
import java.util.Map;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.schema.Column;

public class Update
implements Statement {
    private Table table;
    private Comparison whereComparison;
    private Map<String, String> updateValues;

    public Update(net.sf.jsqlparser.statement.update.Update rawUpdate) {
        this.table = Tables.getTable(((net.sf.jsqlparser.schema.Table)rawUpdate.getTables().get(0)).getName());
        if (rawUpdate.getWhere() == null) {
            this.whereComparison = new AlwaysTrueComparison();
        } else {
            WhereEvaluator whereEvaluator = new WhereEvaluator();
            this.whereComparison = whereEvaluator.evaluateWhere(rawUpdate.getWhere());
        }
        this.updateValues = new HashMap<String, String>();
        int i = 0;
        while (i < rawUpdate.getColumns().size()) {
            String key = ((Column)rawUpdate.getColumns().get(i)).getColumnName();
            String value = ((Expression)rawUpdate.getExpressions().get(i)).toString();
            this.updateValues.put(key, value);
            ++i;
        }
    }

    @Override
    public Table getTable() {
        return this.table;
    }

    public Comparison getWhereComparison() {
        return this.whereComparison;
    }

    public Map<String, String> getUpdateValues() {
        return this.updateValues;
    }
}

