/*
 * Decompiled with CFR 0.152.
 */
package database;

import database.Columns;
import database.Statement;
import database.Tables;
import database.table.Table;
import database.where.AlwaysTrueComparison;
import database.where.Comparison;
import database.where.WhereEvaluator;
import java.util.LinkedList;
import java.util.List;
import net.sf.jsqlparser.statement.select.AllColumns;
import net.sf.jsqlparser.statement.select.AllTableColumns;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.SelectBody;
import net.sf.jsqlparser.statement.select.SelectExpressionItem;
import net.sf.jsqlparser.statement.select.SelectItem;
import net.sf.jsqlparser.statement.select.SelectItemVisitor;
import net.sf.jsqlparser.statement.select.SelectVisitor;
import net.sf.jsqlparser.statement.select.SelectVisitorAdapter;

public class Select
extends SelectVisitorAdapter
implements SelectItemVisitor,
Statement {
    private List<String> rawSelectItems = new LinkedList<String>();
    private Table table = null;
    private Columns columns = null;
    private Comparison whereComparison = null;

    public Select(net.sf.jsqlparser.statement.select.Select rawSelect) {
        SelectBody selectBody = rawSelect.getSelectBody();
        selectBody.accept((SelectVisitor)this);
    }

    public void visit(PlainSelect arg0) {
        this.table = Tables.getTable(arg0.getFromItem().toString());
        if (this.table == null) {
            System.out.println("This table does not exist.");
            return;
        }
        List selectItemList = arg0.getSelectItems();
        for (SelectItem selectItem : selectItemList) {
            selectItem.accept((SelectItemVisitor)this);
        }
        this.columns = this.table.getColumns(this.rawSelectItems.toArray(new String[this.rawSelectItems.size()]));
        if (arg0.getWhere() == null) {
            this.whereComparison = new AlwaysTrueComparison();
        } else {
            WhereEvaluator whereEvaluator = new WhereEvaluator();
            this.whereComparison = whereEvaluator.evaluateWhere(arg0.getWhere());
        }
    }

    public void visit(AllColumns arg0) {
        this.rawSelectItems.add("*");
    }

    public void visit(AllTableColumns arg0) {
        this.rawSelectItems.add(arg0.toString());
    }

    public void visit(SelectExpressionItem arg0) {
        this.rawSelectItems.add(arg0.toString());
    }

    @Override
    public Table getTable() {
        return this.table;
    }

    public Columns getColumns() {
        return this.columns;
    }

    public Comparison getWhereComparison() {
        return this.whereComparison;
    }
}

