/*
 * Decompiled with CFR 0.152.
 */
package database;

import database.Columns;

public class Row {
    private Columns columns;
    private String[] values;

    public Row(Columns columns, String[] values) {
        if (values.length != columns.getLength()) {
            throw new IllegalArgumentException("The amount of entries in the value array must match the amount of columns.");
        }
        this.columns = columns;
        this.values = values;
    }

    public Row createFractionRow(Columns selectedColumns) {
        String[] values = new String[selectedColumns.getLength()];
        String[] columnNames = selectedColumns.getColumnNames();
        int i = 0;
        while (i < values.length) {
            values[i] = this.getValueOf(columnNames[i]);
            ++i;
        }
        return new Row(selectedColumns, values);
    }

    public String getValueOf(String column) {
        if (!this.columns.hasColumn(column)) {
            throw new IllegalArgumentException("Column " + column + " is not contained in this row.");
        }
        return this.values[this.columns.getPositionOf(column)];
    }

    public int getLength() {
        return this.columns.getLength();
    }

    public boolean hasColumn(String column) {
        return this.columns.hasColumn(column);
    }

    public Columns.Type getTypeOf(String column) {
        return this.columns.getTypeOf(column);
    }

    public boolean isNumeric(String column) {
        return this.columns.isNumeric(column);
    }

    public Columns getColumns() {
        return this.columns;
    }

    public String[] getValues() {
        return this.values;
    }
}

