/*
 * Decompiled with CFR 0.152.
 */
package database;

import database.Columns;
import database.Row;
import database.Statement;
import database.Tables;
import database.table.Table;
import java.util.LinkedList;
import java.util.List;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.expression.operators.relational.ItemsList;
import net.sf.jsqlparser.expression.operators.relational.ItemsListVisitor;
import net.sf.jsqlparser.expression.operators.relational.MultiExpressionList;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.statement.select.SubSelect;

public class Insert
implements Statement,
ItemsListVisitor {
    private Table table;
    private Columns columns;
    private List<Row> rows;

    public Insert(net.sf.jsqlparser.statement.insert.Insert rawInsert) {
        this.table = Tables.getTable(rawInsert.getTable().getName());
        if (this.table == null) {
            System.out.println("This table does not exist.");
            return;
        }
        List rawColumns = rawInsert.getColumns();
        String[] columnNames = new String[rawColumns.size()];
        int i = 0;
        while (i < columnNames.length) {
            columnNames[i] = ((Column)rawColumns.get(i)).getColumnName();
            ++i;
        }
        this.columns = this.table.getColumns(columnNames);
        this.rows = new LinkedList<Row>();
        ItemsList itemsList = rawInsert.getItemsList();
        itemsList.accept((ItemsListVisitor)this);
    }

    public void visit(ExpressionList arg0) {
        String[] values = new String[arg0.getExpressions().size()];
        int i = 0;
        while (i < arg0.getExpressions().size()) {
            Expression expression = (Expression)arg0.getExpressions().get(i);
            values[i] = expression.toString();
            ++i;
        }
        this.rows.add(new Row(this.columns, values));
    }

    public void visit(MultiExpressionList arg0) {
        for (ExpressionList expressionList : arg0.getExprList()) {
            this.visit(expressionList);
        }
    }

    public void visit(SubSelect arg0) {
        System.out.println("There is no support for insertion with subselects yet.");
    }

    @Override
    public Table getTable() {
        return this.table;
    }

    public Columns getColumns() {
        return this.columns;
    }

    public List<Row> getRows() {
        return this.rows;
    }
}

