/*
 * Decompiled with CFR 0.152.
 */
package database;

import database.Row;
import java.util.Arrays;
import java.util.Map;

public class Columns {
    private String[] columns;
    private Type[] types;
    private boolean[] updatable;

    public Columns(String[] columns, Type[] types) {
        if (columns.length != types.length) {
            throw new IllegalArgumentException("The amount of entries in the passed arrays must match");
        }
        this.columns = columns;
        this.types = types;
        this.updatable = new boolean[types.length];
        Arrays.fill(this.updatable, true);
    }

    public Columns(String[] columns, Type[] types, boolean[] updatable) {
        if (columns.length != types.length || columns.length != updatable.length) {
            throw new IllegalArgumentException("The amount of entries in the passed arrays must match");
        }
        this.columns = columns;
        this.types = types;
        this.updatable = updatable;
    }

    public String[] createEmptyRowValues() {
        String[] values = new String[this.types.length];
        int i = 0;
        while (i < this.types.length) {
            values[i] = this.types[i] == Type.text || this.types[i] == Type.other ? "" : "0";
            ++i;
        }
        return values;
    }

    public Row createEmptyRow() {
        return new Row(this, this.createEmptyRowValues());
    }

    public boolean hasColumn(String column) {
        return this.getPositionOf(column) != -1;
    }

    public int getPositionOf(String column) {
        int i = 0;
        while (i < this.columns.length) {
            if (this.columns[i].equalsIgnoreCase(column)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public Type getTypeOf(String column) {
        if (!this.hasColumn(column)) {
            throw new IllegalArgumentException("the passed column " + column + " is not contained in this table.");
        }
        return this.types[this.getPositionOf(column)];
    }

    public boolean isNumeric(String column) {
        Type type = this.getTypeOf(column);
        return type == Type.number || type == Type.integer;
    }

    public boolean isUpdatable(String column) {
        return this.updatable[this.getPositionOf(column)];
    }

    public boolean containsNonUpdatableFields(Map<String, String> updateValues) {
        for (String key : updateValues.keySet()) {
            if (this.isUpdatable(key)) continue;
            return true;
        }
        return false;
    }

    public int getLength() {
        return this.columns.length;
    }

    public String[] getColumnNames() {
        return (String[])this.columns.clone();
    }

    public static enum Type {
        text,
        number,
        integer,
        other;

    }
}

