/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.JPanel;

public class ProgressDisplayPanel
extends JPanel {
    private int progress = 0;
    private Font font = new Font("Arial", 1, 20);
    private Color lightBlue = new Color(38, 112, 188);

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setPaintMode();
        int currentHeight = this.getHeight();
        int currentWidth = this.getWidth();
        if (this.progress == 0) {
            g2d.setColor(Color.gray);
        } else {
            float percentageFactor = (float)this.progress / 100.0f;
            g2d.setColor(this.lightBlue);
            g2d.fillArc(31, 31, currentWidth - 65, currentHeight - 65, 90, -Math.round(360.0f * percentageFactor));
            g2d.setColor(Color.black);
        }
        g2d.setStroke(new BasicStroke(2.0f));
        g2d.drawOval(21, 21, currentWidth - 45, currentHeight - 45);
        g2d.setFont(this.font);
        g2d.drawString(String.valueOf(this.progress) + " %", currentWidth / 2 - 15, currentHeight / 2);
    }

    public void updateProgress(int progress) {
        this.progress = progress;
        this.repaint();
    }
}

