/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.HeadlessException;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import model.EsFile;
import net.sf.jsqlparser.JSQLParserException;

public class IdPatchMainFrame
extends JFrame {
    private FileSelectorPanel fileSelectorPanel;
    private PatchPanel patchPanel;
    private ProgressDisplayPanel progressDisplayPanel;
    private List<Translation> translations;
    private FilePatcher filePatcher;

    public IdPatchMainFrame() throws HeadlessException, IOException {
        super("Tamriel-Data Filepatcher");
        this.setDefaultCloseOperation(3);
        this.setSize(650, 380);
        this.setLayout(new BorderLayout());
        URL applicationRootPathURL = this.getClass().getProtectionDomain().getCodeSource().getLocation();
        File applicationRootPath = new File(applicationRootPathURL.getPath());
        File file = applicationRootPath.isDirectory() ? new File(applicationRootPath, "Translation.txt") : new File(applicationRootPath.getParentFile(), "Translation.txt");
        if (!file.exists() && !(file = new File(String.valueOf(System.getProperty("user.dir")) + File.separatorChar + "Translation.txt")).exists()) {
            this.addErrorNotification("<html>The Translation.txt is not available. Please add it to the current folder and restart the program.</html>");
            return;
        }
        try {
            this.translations = TranslationFileReader.readTranslationsFromFile(file.getCanonicalPath());
        }
        catch (IOException e) {
            this.addErrorNotification("<html>The Translation.txt could not be read. Please make sure that there are no syntax errors in the file and restart the program.</html>");
            e.printStackTrace();
            return;
        }
        this.filePatcher = new FilePatcher(this);
        this.fileSelectorPanel = new FileSelectorPanel(this);
        this.fileSelectorPanel.setLayout(new FlowLayout());
        this.add((Component)this.fileSelectorPanel, "North");
        JPanel centerPanel = new JPanel();
        centerPanel.setLayout(new GridLayout(1, 2));
        this.patchPanel = new PatchPanel(this);
        centerPanel.add(this.patchPanel);
        this.progressDisplayPanel = new ProgressDisplayPanel();
        centerPanel.add(this.progressDisplayPanel);
        this.add((Component)centerPanel, "Center");
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        try {
            IdPatchMainFrame mainFrame = new IdPatchMainFrame();
            mainFrame.setVisible(true);
        }
        catch (HeadlessException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    void startPatch() {
        this.fileSelectorPanel.setLoadButtonEnabled(false);
        this.patchPanel.setButtonEnabled(false);
        List<String> fileNames = this.fileSelectorPanel.getSelectedFiles();
        final LinkedList<EsFile> esFiles = new LinkedList<EsFile>();
        for (String fileName : fileNames) {
            try {
                esFiles.add(new EsFile(fileName));
            }
            catch (IOException e) {
                this.addErrorNotification("An error occured while trying to read the files to be patched.");
                e.printStackTrace();
                return;
            }
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    IdPatchMainFrame.this.filePatcher.patchFiles(esFiles, IdPatchMainFrame.this.translations, "Tamriel_Data.esm", 7501911, IdPatchMainFrame.this.patchPanel.backupsEnabled());
                }
                catch (JSQLParserException e) {
                    IdPatchMainFrame.this.addErrorNotification("An error occured while trying to patch the files.");
                    e.printStackTrace();
                }
            }
        };
        Thread thread = new Thread(runnable);
        thread.setPriority(10);
        thread.start();
    }

    synchronized void notifyAboutCurrentFile(String currentFile) {
        this.patchPanel.setInfo("Patching " + currentFile + "...");
    }

    synchronized void notifyAboutProgress(int percent, boolean finished) {
        this.progressDisplayPanel.updateProgress(percent);
        if (finished) {
            this.fileSelectorPanel.setLoadButtonEnabled(true);
            this.patchPanel.setButtonEnabled(true);
            this.patchPanel.setInfo("Finished");
        }
    }

    synchronized void notifyAboutLastObject(String object) {
        this.patchPanel.setLastId(object);
    }

    void addErrorNotification(String text) {
        JLabel notificationLabel = new JLabel(text);
        notificationLabel.setForeground(Color.red);
        notificationLabel.setFont(new Font("Arial", 1, 20));
        this.add((Component)notificationLabel, "Center");
    }
}

