/*
 * Decompiled with CFR 0.152.
 */
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileNameExtensionFilter;

public class FileSelectorPanel
extends JPanel
implements ActionListener {
    private List<String> selectedFiles;
    private JTextField selectedFilesTextField;
    private JFrame parentFrame;
    private JButton openFileDialogueButton;

    public FileSelectorPanel(JFrame parentFrame) {
        this.parentFrame = parentFrame;
        this.selectedFiles = new LinkedList<String>();
        this.selectedFilesTextField = new JTextField(40);
        this.selectedFilesTextField.setEditable(false);
        this.openFileDialogueButton = new JButton("Open Files");
        this.openFileDialogueButton.addActionListener(this);
        this.add(this.selectedFilesTextField);
        this.add(this.openFileDialogueButton);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.openFileDialogueButton.setEnabled(false);
        JFileChooser fileChooser = new JFileChooser(System.getProperty("user.dir"));
        FileNameExtensionFilter filter = new FileNameExtensionFilter("Morrowind Plugin & Savegame Files", "ess", "esp", "esm");
        fileChooser.setFileFilter(filter);
        fileChooser.setMultiSelectionEnabled(true);
        int returnValue = fileChooser.showOpenDialog(this.parentFrame);
        this.openFileDialogueButton.setEnabled(true);
        if (returnValue != 0) {
            return;
        }
        File[] selectedFiles = fileChooser.getSelectedFiles();
        if (selectedFiles.length == 0) {
            return;
        }
        this.selectedFiles.clear();
        StringBuilder sB = new StringBuilder();
        File[] fileArray = selectedFiles;
        int n = selectedFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            try {
                this.selectedFiles.add(file.getCanonicalPath());
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            sB.append('\"');
            sB.append(file.getName());
            sB.append("\" ");
            ++n2;
        }
        this.selectedFilesTextField.setText(sB.toString());
    }

    void setLoadButtonEnabled(boolean enabled) {
        this.openFileDialogueButton.setEnabled(enabled);
    }

    public List<String> getSelectedFiles() {
        return this.selectedFiles;
    }
}

