/*
 * Decompiled with CFR 0.152.
 */
import database.Row;
import database.Statement;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import model.EsFile;
import model.ModelFunctions;
import model.Record;
import model.SubRecord;
import model.subrecorddata.SubRecordData;
import model.subrecorddata.SubRecordDataString;
import model.subrecorddata.SubrecordDataNPDT;
import model.subrecorddata.SubrecordDataSPDT;
import model.subrecorddata.SubrecordDataVFXMEntry;
import net.sf.jsqlparser.JSQLParserException;
import processor.FileProcessingOrder;
import processor.FileProcessor;
import processor.StatementProcessingResult;

public class FilePatcher {
    private IdPatchMainFrame mainFrame;

    public FilePatcher(IdPatchMainFrame mainFrame) {
        this.mainFrame = mainFrame;
    }

    public void patchFiles(List<EsFile> esFiles, List<Translation> translations, String newMasterFileName, int newMasterFileSize, boolean createBackups) throws JSQLParserException {
        FileProcessor fileProcessor = new FileProcessor();
        int currentFile = 0;
        for (EsFile esFile : esFiles) {
            String newId;
            this.mainFrame.notifyAboutCurrentFile(esFile.getFileName().substring(esFile.getFileName().lastIndexOf(File.separatorChar) + 1));
            if (createBackups) {
                String currentFileName = esFile.getFileName();
                esFile.setFileName(String.valueOf(currentFileName) + ".bak");
                esFile.writeToFileSystem();
                esFile.setFileName(currentFileName);
            }
            boolean saveGame = esFile.getFileName().toLowerCase().endsWith("ess");
            FileProcessingOrder order = FileProcessingOrder.fromSql("DELETE FROM masterFiles WHERE name='TR_Data.esm' OR name='PC_Data.esm' OR name='Skyrim_Data.esm';");
            fileProcessor.processStatement(esFile, order.getStatements().get(0));
            order = FileProcessingOrder.fromSql("DELETE FROM masterFiles WHERE name='" + newMasterFileName + "';");
            fileProcessor.processStatement(esFile, order.getStatements().get(0));
            order = FileProcessingOrder.fromSql("INSERT INTO masterFiles (name, size) VALUES ('" + newMasterFileName + "'," + newMasterFileSize + ");");
            fileProcessor.processStatement(esFile, order.getStatements().get(0));
            ArrayList<String> duplicateIds = new ArrayList<String>();
            HashMap<String, String> translationMap = new HashMap<String, String>(70000);
            Statement scriptLoadStatement = FileProcessingOrder.fromSql("SELECT * FROM scripts;").getStatements().get(0);
            Statement dialogueLoadStatement = FileProcessingOrder.fromSql("SELECT * FROM dialogueResponses;").getStatements().get(0);
            order = FileProcessingOrder.fromSql("SELECT * FROM cellObjects; SELECT * FROM itemReferences; SELECT * FROM spellReferences; SELECT * FROM creatureReferences; SELECT * FROM classReferences; SELECT * FROM factionReferences; SELECT * FROM enchantmentReferences; SELECT * FROM bodypartReferences; SELECT * FROM scriptReferences; SELECT * FROM soundReferences; SELECT * FROM dialogueResponses; SELECT * FROM exteriorCells;");
            List<StatementProcessingResult> results = fileProcessor.processOrder(esFile, order);
            long handledEntries = 0L;
            long totalEntries = saveGame ? translations.size() + esFile.getRecords().size() : translations.size();
            for (StatementProcessingResult result : results) {
                totalEntries += (long)result.getRows().size();
            }
            for (Translation translation : translations) {
                translationMap.put(translation.getPreviousId().toLowerCase(), translation.getNewId());
                this.mainFrame.notifyAboutLastObject("idObjects: " + translation.getNewId());
                boolean duplicate = duplicateIds.contains(translation.getNewId());
                if (duplicate && translation.getNewId().endsWith("Region") || !saveGame && (duplicate || !translation.getNewId().startsWith("T_"))) {
                    order = FileProcessingOrder.fromSql("DELETE FROM idObjects WHERE id=" + ModelFunctions.getEscapedString(translation.getPreviousId()) + ";");
                    fileProcessor.processStatement(esFile, order.getStatements().get(0));
                } else {
                    order = FileProcessingOrder.fromSql("UPDATE idObjects SET id=" + ModelFunctions.getEscapedString(translation.getNewId()) + " WHERE id=" + ModelFunctions.getEscapedString(translation.getPreviousId()) + ";");
                    fileProcessor.processStatement(esFile, order.getStatements().get(0));
                    duplicateIds.add(translation.getNewId());
                }
                List<Row> scriptRows = fileProcessor.processStatement(esFile, scriptLoadStatement);
                for (Row row : scriptRows) {
                    String text;
                    String name = row.getValueOf("name");
                    if (name.equalsIgnoreCase(translation.getPreviousId())) {
                        if (!saveGame && duplicate) {
                            order = FileProcessingOrder.fromSql("DELETE FROM scripts WHERE name ='" + name + "';");
                            fileProcessor.processStatement(esFile, order.getStatements().get(0));
                            continue;
                        }
                        order = FileProcessingOrder.fromSql("UPDATE scripts SET name ='" + translation.getNewId() + "' WHERE name='" + name + "';");
                        fileProcessor.processStatement(esFile, order.getStatements().get(0));
                        name = translation.getNewId();
                    }
                    if ((text = row.getValueOf("text")) == null) continue;
                    text = text.trim();
                    while (!text.startsWith("b") && !text.startsWith("B")) {
                        text = text.substring(1);
                    }
                    String textChanged = text.replaceAll("(?i)" + translation.getPreviousId(), translation.getNewId());
                    if (!textChanged.toLowerCase().startsWith("begin " + name.toLowerCase())) {
                        String messedUpHeader = textChanged.substring(0, textChanged.indexOf(13));
                        textChanged = textChanged.replaceAll(messedUpHeader, "Begin " + name);
                    }
                    if (textChanged.equals(text)) continue;
                    order = FileProcessingOrder.fromSql("UPDATE scripts SET text =" + ModelFunctions.getEscapedString(textChanged) + " WHERE name='" + name + "';");
                    fileProcessor.processStatement(esFile, order.getStatements().get(0));
                }
                float progress = (float)(++handledEntries) * 100.0f / (float)totalEntries / (float)esFiles.size();
                this.mainFrame.notifyAboutProgress((int)(progress += (float)currentFile * (100.0f / (float)esFiles.size())), false);
            }
            ArrayList<String> completedTranslations = new ArrayList<String>(70000);
            for (Record record : esFile.getRecords()) {
                if (!record.getName().equals("CELL")) continue;
                boolean cellObjectsStarted = false;
                for (SubRecord subRecord : record.getSubRecords()) {
                    if (cellObjectsStarted) {
                        if (!subRecord.getName().equals("NAME")) continue;
                        float progress = (float)(++handledEntries) * 100.0f / (float)totalEntries / (float)esFiles.size();
                        this.mainFrame.notifyAboutProgress((int)(progress += (float)currentFile * (100.0f / (float)esFiles.size())), false);
                        String id = subRecord.getData().getValueAsString().toLowerCase().replaceAll("\n", "").replaceAll("\r", "");
                        if (!translationMap.containsKey(id)) continue;
                        SubRecordDataString data = (SubRecordDataString)subRecord.getData();
                        data.setValue((String)translationMap.get(id));
                        continue;
                    }
                    if (subRecord.getName().equals("FRMR")) {
                        cellObjectsStarted = true;
                        continue;
                    }
                    if (!subRecord.getName().equals("NAME")) continue;
                    this.mainFrame.notifyAboutLastObject("cellObjects in: \"" + subRecord.getData().getValueAsString() + "\"");
                }
            }
            for (Row row : results.get(1).getRows()) {
                float progress = (float)(++handledEntries) * 100.0f / (float)totalEntries / (float)esFiles.size();
                this.mainFrame.notifyAboutProgress((int)(progress += (float)currentFile * (100.0f / (float)esFiles.size())), false);
                String id = row.getValueOf("item").toLowerCase();
                if (!translationMap.containsKey(id) || Collections.binarySearch(completedTranslations, id) >= 0) continue;
                newId = (String)translationMap.get(id);
                this.mainFrame.notifyAboutLastObject("itemReferences: " + newId);
                order = FileProcessingOrder.fromSql("UPDATE itemReferences SET item='" + newId + "' WHERE item=" + ModelFunctions.getEscapedString(id) + ";");
                fileProcessor.processStatement(esFile, order.getStatements().get(0));
                completedTranslations.add(id);
                Collections.sort(completedTranslations);
            }
            completedTranslations.clear();
            for (Row row : results.get(2).getRows()) {
                float progress = (float)(++handledEntries) * 100.0f / (float)totalEntries / (float)esFiles.size();
                this.mainFrame.notifyAboutProgress((int)(progress += (float)currentFile * (100.0f / (float)esFiles.size())), false);
                String id = row.getValueOf("spell").toLowerCase();
                if (!translationMap.containsKey(id)) {
                    if (id.startsWith("tr_")) continue;
                    id.startsWith("pc_");
                    continue;
                }
                if (Collections.binarySearch(completedTranslations, id) >= 0) continue;
                newId = (String)translationMap.get(id);
                this.mainFrame.notifyAboutLastObject("spellReferences: " + newId);
                order = FileProcessingOrder.fromSql("UPDATE spellReferences SET spell='" + newId + "' WHERE spell=" + ModelFunctions.getEscapedString(id) + ";");
                fileProcessor.processStatement(esFile, order.getStatements().get(0));
                completedTranslations.add(id);
                Collections.sort(completedTranslations);
            }
            completedTranslations.clear();
            for (Row row : results.get(3).getRows()) {
                float progress = (float)(++handledEntries) * 100.0f / (float)totalEntries / (float)esFiles.size();
                this.mainFrame.notifyAboutProgress((int)(progress += (float)currentFile * (100.0f / (float)esFiles.size())), false);
                String id = row.getValueOf("creature").toLowerCase();
                if (!translationMap.containsKey(id) || Collections.binarySearch(completedTranslations, id) >= 0) continue;
                newId = (String)translationMap.get(id);
                this.mainFrame.notifyAboutLastObject("creatureReferences: " + newId);
                order = FileProcessingOrder.fromSql("UPDATE creatureReferences SET creature='" + newId + "' WHERE creature=" + ModelFunctions.getEscapedString(id) + ";");
                fileProcessor.processStatement(esFile, order.getStatements().get(0));
                completedTranslations.add(id);
                Collections.sort(completedTranslations);
            }
            completedTranslations.clear();
            for (Row row : results.get(4).getRows()) {
                float progress = (float)(++handledEntries) * 100.0f / (float)totalEntries / (float)esFiles.size();
                this.mainFrame.notifyAboutProgress((int)(progress += (float)currentFile * (100.0f / (float)esFiles.size())), false);
                String id = row.getValueOf("class").toLowerCase();
                if (!translationMap.containsKey(id) || Collections.binarySearch(completedTranslations, id) >= 0) continue;
                newId = (String)translationMap.get(id);
                this.mainFrame.notifyAboutLastObject("classReferences: " + newId);
                order = FileProcessingOrder.fromSql("UPDATE classReferences SET class='" + newId + "' WHERE class=" + ModelFunctions.getEscapedString(id) + ";");
                fileProcessor.processStatement(esFile, order.getStatements().get(0));
                completedTranslations.add(id);
                Collections.sort(completedTranslations);
            }
            completedTranslations.clear();
            for (Row row : results.get(5).getRows()) {
                float progress = (float)(++handledEntries) * 100.0f / (float)totalEntries / (float)esFiles.size();
                this.mainFrame.notifyAboutProgress((int)(progress += (float)currentFile * (100.0f / (float)esFiles.size())), false);
                String id = row.getValueOf("faction").toLowerCase();
                if (!translationMap.containsKey(id) || Collections.binarySearch(completedTranslations, id) >= 0) continue;
                newId = (String)translationMap.get(id);
                this.mainFrame.notifyAboutLastObject("factionReferences: " + newId);
                order = FileProcessingOrder.fromSql("UPDATE factionReferences SET faction='" + newId + "' WHERE faction=" + ModelFunctions.getEscapedString(id) + ";");
                fileProcessor.processStatement(esFile, order.getStatements().get(0));
                completedTranslations.add(id);
                Collections.sort(completedTranslations);
            }
            completedTranslations.clear();
            for (Row row : results.get(6).getRows()) {
                float progress = (float)(++handledEntries) * 100.0f / (float)totalEntries / (float)esFiles.size();
                this.mainFrame.notifyAboutProgress((int)(progress += (float)currentFile * (100.0f / (float)esFiles.size())), false);
                String id = row.getValueOf("enchantment").toLowerCase();
                if (!translationMap.containsKey(id) || Collections.binarySearch(completedTranslations, id) >= 0) continue;
                newId = (String)translationMap.get(id);
                this.mainFrame.notifyAboutLastObject("enchantmentReferences: " + newId);
                order = FileProcessingOrder.fromSql("UPDATE enchantmentReferences SET enchantment='" + newId + "' WHERE enchantment=" + ModelFunctions.getEscapedString(id) + ";");
                fileProcessor.processStatement(esFile, order.getStatements().get(0));
                completedTranslations.add(id);
                Collections.sort(completedTranslations);
            }
            completedTranslations.clear();
            for (Row row : results.get(7).getRows()) {
                float progress = (float)(++handledEntries) * 100.0f / (float)totalEntries / (float)esFiles.size();
                this.mainFrame.notifyAboutProgress((int)(progress += (float)currentFile * (100.0f / (float)esFiles.size())), false);
                String id = row.getValueOf("bodypart").toLowerCase();
                if (!translationMap.containsKey(id) || Collections.binarySearch(completedTranslations, id) >= 0) continue;
                newId = (String)translationMap.get(id);
                this.mainFrame.notifyAboutLastObject("bodypartReferences: " + newId);
                order = FileProcessingOrder.fromSql("UPDATE bodypartReferences SET bodypart='" + newId + "' WHERE bodypart=" + ModelFunctions.getEscapedString(id) + ";");
                fileProcessor.processStatement(esFile, order.getStatements().get(0));
                completedTranslations.add(id);
                Collections.sort(completedTranslations);
            }
            completedTranslations.clear();
            for (Row row : results.get(8).getRows()) {
                float progress = (float)(++handledEntries) * 100.0f / (float)totalEntries / (float)esFiles.size();
                this.mainFrame.notifyAboutProgress((int)(progress += (float)currentFile * (100.0f / (float)esFiles.size())), false);
                String id = row.getValueOf("script").toLowerCase();
                if (!translationMap.containsKey(id) || Collections.binarySearch(completedTranslations, id) >= 0) continue;
                newId = (String)translationMap.get(id);
                this.mainFrame.notifyAboutLastObject("scriptReferences: " + newId);
                order = FileProcessingOrder.fromSql("UPDATE scriptReferences SET script='" + newId + "' WHERE script=" + ModelFunctions.getEscapedString(id) + ";");
                fileProcessor.processStatement(esFile, order.getStatements().get(0));
                completedTranslations.add(id);
                Collections.sort(completedTranslations);
            }
            completedTranslations.clear();
            for (Row row : results.get(9).getRows()) {
                float progress = (float)(++handledEntries) * 100.0f / (float)totalEntries / (float)esFiles.size();
                this.mainFrame.notifyAboutProgress((int)(progress += (float)currentFile * (100.0f / (float)esFiles.size())), false);
                String id = row.getValueOf("sound").toLowerCase();
                if (!translationMap.containsKey(id) || Collections.binarySearch(completedTranslations, id) >= 0) continue;
                newId = (String)translationMap.get(id);
                this.mainFrame.notifyAboutLastObject("soundReferences: " + newId);
                order = FileProcessingOrder.fromSql("UPDATE soundReferences SET sound='" + newId + "' WHERE sound=" + ModelFunctions.getEscapedString(id) + ";");
                fileProcessor.processStatement(esFile, order.getStatements().get(0));
                completedTranslations.add(id);
                Collections.sort(completedTranslations);
            }
            completedTranslations.clear();
            for (Row row : results.get(10).getRows()) {
                String resultText;
                String playersFaction;
                String faction;
                String npcClass;
                float progress = (float)(++handledEntries) * 100.0f / (float)totalEntries / (float)esFiles.size();
                this.mainFrame.notifyAboutProgress((int)(progress += (float)currentFile * (100.0f / (float)esFiles.size())), false);
                String responseId = row.getValueOf("id");
                this.mainFrame.notifyAboutLastObject("dialogueResponses: " + responseId);
                String npc = row.getValueOf("npc").toLowerCase();
                if (translationMap.containsKey(npc)) {
                    order = FileProcessingOrder.fromSql("UPDATE dialogueResponses SET npc ='" + (String)translationMap.get(npc) + "' WHERE id='" + responseId + "';");
                    fileProcessor.processStatement(esFile, order.getStatements().get(0));
                }
                if (translationMap.containsKey(npcClass = row.getValueOf("class").toLowerCase())) {
                    order = FileProcessingOrder.fromSql("UPDATE dialogueResponses SET class ='" + (String)translationMap.get(npcClass) + "' WHERE id='" + responseId + "';");
                    fileProcessor.processStatement(esFile, order.getStatements().get(0));
                }
                if (translationMap.containsKey(faction = row.getValueOf("faction").toLowerCase())) {
                    order = FileProcessingOrder.fromSql("UPDATE dialogueResponses SET faction ='" + (String)translationMap.get(faction) + "' WHERE id='" + responseId + "';");
                    fileProcessor.processStatement(esFile, order.getStatements().get(0));
                }
                if (translationMap.containsKey(playersFaction = row.getValueOf("playersFaction").toLowerCase())) {
                    order = FileProcessingOrder.fromSql("UPDATE dialogueResponses SET playersFaction ='" + (String)translationMap.get(playersFaction) + "' WHERE id='" + responseId + "';");
                    fileProcessor.processStatement(esFile, order.getStatements().get(0));
                }
                int i = 1;
                while (i <= 6) {
                    String currentValue = row.getValueOf("func" + i + "Value").toLowerCase();
                    if (translationMap.containsKey(currentValue)) {
                        order = FileProcessingOrder.fromSql("UPDATE dialogueResponses SET func" + i + "Value ='" + translationMap.get(currentValue) + "' WHERE id='" + responseId + "';");
                        fileProcessor.processStatement(esFile, order.getStatements().get(0));
                    }
                    ++i;
                }
                String resultTextChanged = resultText = row.getValueOf("resultText");
                LinkedList<String> resultTextElements = new LinkedList<String>();
                String[] resultTextSplit = resultText.split("\"");
                int i2 = 0;
                while (i2 < resultTextSplit.length) {
                    String element = resultTextSplit[i2];
                    if (i2 % 2 == 1) {
                        resultTextElements.add(element);
                    } else {
                        String[] elementSplit1;
                        String[] stringArray = elementSplit1 = element.split("\n");
                        int n = elementSplit1.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String[] elementSplit2;
                            String elementSplitLine1 = stringArray[n2];
                            String[] stringArray2 = elementSplit2 = elementSplitLine1.split("\r");
                            int n3 = elementSplit2.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                String[] elementSplit3;
                                String elementSplitLine2 = stringArray2[n4];
                                String[] stringArray3 = elementSplit3 = elementSplitLine2.split(" ");
                                int n5 = elementSplit3.length;
                                int n6 = 0;
                                while (n6 < n5) {
                                    String[] elementSplit4;
                                    String elementSplitLine3 = stringArray3[n6];
                                    String[] stringArray4 = elementSplit4 = elementSplitLine3.split(",");
                                    int n7 = elementSplit4.length;
                                    int n8 = 0;
                                    while (n8 < n7) {
                                        String elementSplitLine4 = stringArray4[n8];
                                        resultTextElements.add(elementSplitLine4);
                                        ++n8;
                                    }
                                    ++n6;
                                }
                                ++n4;
                            }
                            ++n2;
                        }
                    }
                    ++i2;
                }
                for (String element : resultTextElements) {
                    if (!translationMap.containsKey(element.toLowerCase())) continue;
                    resultTextChanged = resultTextChanged.replaceAll(element, translationMap.get(element.toLowerCase()));
                }
                if (resultTextChanged.equals(resultText)) continue;
                order = FileProcessingOrder.fromSql("UPDATE dialogueResponses SET resultText =" + ModelFunctions.getEscapedString(resultTextChanged) + " WHERE id='" + responseId + "';");
                fileProcessor.processStatement(esFile, order.getStatements().get(0));
            }
            for (Row row : results.get(11).getRows()) {
                float progress = (float)(++handledEntries) * 100.0f / (float)totalEntries / (float)esFiles.size();
                this.mainFrame.notifyAboutProgress((int)(progress += (float)currentFile * (100.0f / (float)esFiles.size())), false);
                String id = row.getValueOf("region").toLowerCase();
                if (!translationMap.containsKey(id) || Collections.binarySearch(completedTranslations, id) >= 0) continue;
                newId = (String)translationMap.get(id);
                this.mainFrame.notifyAboutLastObject("exteriorCells: " + newId);
                order = FileProcessingOrder.fromSql("UPDATE exteriorCells SET region=" + ModelFunctions.getEscapedString(newId) + " WHERE region=" + ModelFunctions.getEscapedString(id) + ";");
                fileProcessor.processStatement(esFile, order.getStatements().get(0));
                completedTranslations.add(id);
                Collections.sort(completedTranslations);
            }
            completedTranslations.clear();
            if (saveGame) {
                this.mainFrame.notifyAboutLastObject("savegame - clearing region entries");
                order = FileProcessingOrder.fromSql("DELETE FROM idObjects WHERE type='region';");
                fileProcessor.processStatement(esFile, order.getStatements().get(0));
                this.mainFrame.notifyAboutLastObject("savegame - creatures & containers & spelleffects");
                for (Record record : esFile.getRecords()) {
                    String newAffectedNpcId;
                    String affectedNpcId;
                    float progress = (float)(++handledEntries) * 100.0f / (float)totalEntries / (float)esFiles.size();
                    this.mainFrame.notifyAboutProgress((int)(progress += (float)currentFile * (100.0f / (float)esFiles.size())), false);
                    if (record.getName().equals("CELL")) {
                        boolean referencesStarted = false;
                        for (SubRecord subrecord : record.getSubRecords()) {
                            SubRecordDataString data;
                            String referenceIdWithDigits;
                            String newId2;
                            if (subrecord.getName().equals("FRMR") && !referencesStarted) {
                                referencesStarted = true;
                                continue;
                            }
                            if (!subrecord.getName().equals("NAME") && !subrecord.getName().equals("XSOL") && !subrecord.getName().equals("ANAM") || !referencesStarted || (newId2 = this.retrieveNewIdWithDigits(translationMap, referenceIdWithDigits = (data = (SubRecordDataString)subrecord.getData()).getValueAsString())) == null) continue;
                            data.setValue(newId2);
                        }
                        continue;
                    }
                    if (record.getName().equals("REFR")) {
                        for (SubRecord subrecord : record.getSubRecords()) {
                            SubRecordDataString data;
                            String referenceIdWithDigits;
                            String newId3;
                            if (!subrecord.getName().equals("TGTN") || (newId3 = this.retrieveNewIdWithDigits(translationMap, referenceIdWithDigits = (data = (SubRecordDataString)subrecord.getData()).getValueAsString())) == null) continue;
                            data.setValue(newId3);
                        }
                        continue;
                    }
                    if (record.getName().equals("SPLM")) {
                        for (SubRecord subrecord : record.getSubRecords()) {
                            SubRecordData data;
                            if (subrecord.getName().equals("SPDT")) {
                                String casterId;
                                data = (SubrecordDataSPDT)subrecord.getData();
                                if (translationMap.containsKey(((SubrecordDataSPDT)data).getItemId().toLowerCase())) {
                                    ((SubrecordDataSPDT)data).setItemId(translationMap.get(((SubrecordDataSPDT)data).getItemId().toLowerCase()));
                                }
                                if (translationMap.containsKey(((SubrecordDataSPDT)data).getSpellId().toLowerCase())) {
                                    ((SubrecordDataSPDT)data).setSpellId(translationMap.get(((SubrecordDataSPDT)data).getSpellId().toLowerCase()));
                                }
                                if (translationMap.containsKey(casterId = ((SubrecordDataSPDT)data).getCasterId().toLowerCase())) {
                                    ((SubrecordDataSPDT)data).setCasterId(translationMap.get(casterId));
                                    continue;
                                }
                                String newCasterId = this.retrieveNewIdWithDigits(translationMap, casterId);
                                if (newCasterId == null) continue;
                                ((SubrecordDataSPDT)data).setCasterId(newCasterId);
                                continue;
                            }
                            if (!subrecord.getName().equals("NPDT")) continue;
                            data = (SubrecordDataNPDT)subrecord.getData();
                            affectedNpcId = ((SubrecordDataNPDT)data).getAffectedNpcId().toLowerCase();
                            if (translationMap.containsKey(affectedNpcId)) {
                                ((SubrecordDataNPDT)data).setAffectedNpcId(translationMap.get(affectedNpcId));
                                continue;
                            }
                            newAffectedNpcId = this.retrieveNewIdWithDigits(translationMap, affectedNpcId);
                            if (newAffectedNpcId == null) continue;
                            ((SubrecordDataNPDT)data).setAffectedNpcId(newAffectedNpcId);
                        }
                        continue;
                    }
                    if (!record.getName().equals("VFXM")) continue;
                    for (SubRecord subrecord : record.getSubRecords()) {
                        if (!subrecord.getName().equals("VNAM")) continue;
                        SubrecordDataVFXMEntry data = (SubrecordDataVFXMEntry)subrecord.getData();
                        affectedNpcId = data.getTargetNPCId().toLowerCase();
                        if (translationMap.containsKey(affectedNpcId)) {
                            data.setTargetNPCId(translationMap.get(affectedNpcId));
                            continue;
                        }
                        newAffectedNpcId = this.retrieveNewIdWithDigits(translationMap, affectedNpcId);
                        if (newAffectedNpcId == null) continue;
                        data.setTargetNPCId(newAffectedNpcId);
                    }
                }
            }
            esFile.writeToFileSystem();
            ++currentFile;
        }
        this.mainFrame.notifyAboutLastObject("");
        this.mainFrame.notifyAboutProgress(100, true);
    }

    private String retrieveNewIdWithDigits(Map<String, String> translationMap, String referenceIdWithDigits) {
        if (referenceIdWithDigits.length() <= 8) {
            return null;
        }
        String referenceIdWithoutDigits = referenceIdWithDigits.substring(0, referenceIdWithDigits.length() - 8).toLowerCase();
        if (translationMap.containsKey(referenceIdWithoutDigits)) {
            String translation = translationMap.get(referenceIdWithoutDigits);
            if (translation.length() > 23) {
                translation = translation.substring(0, 23);
            }
            return String.valueOf(translation) + referenceIdWithDigits.substring(referenceIdWithDigits.length() - 8);
        }
        return null;
    }

    private boolean typeIsSpell(String type) {
        return type.equals("spell");
    }

    private boolean typeIsSound(String type) {
        return type.equals("sound");
    }

    private boolean typeIsScript(String type) {
        return type.equals("script");
    }

    private boolean typeIsItem(String type) {
        return type.equals("misc item") || type.equals("weapon") || type.equals("light") || type.equals("armor") || type.equals("clothing") || type.equals("repair item") || type.equals("apparatus") || type.equals("lockpick") || type.equals("probe") || type.equals("ingredient") || type.equals("book") || type.equals("alchemy") || type.equals("levelled item");
    }

    private boolean typeIsFaction(String type) {
        return type.equals("faction");
    }

    private boolean typeIsEnchantment(String type) {
        return type.equals("enchantment");
    }

    private boolean typeIsNpcOrCreature(String type) {
        return type.equals("npc") || type.equals("creature") || type.equals("levelled creature");
    }

    private boolean typeIsClass(String type) {
        return type.equals("class");
    }

    private boolean typeIsBodypart(String type) {
        return type.equals("bodypart");
    }

    private boolean typeIsCellObject(String type) {
        return type.equals("static") || type.equals("door") || type.equals("misc item") || type.equals("weapon") || type.equals("container") || type.equals("creature") || type.equals("bodypart") || type.equals("light") || type.equals("npc") || type.equals("armor") || type.equals("clothing") || type.equals("repair item") || type.equals("activator") || type.equals("apparatus") || type.equals("lockpick") || type.equals("probe") || type.equals("ingredient") || type.equals("book") || type.equals("alchemy") || type.equals("levelled creature");
    }
}

